% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nams.R
\name{nams}
\alias{nams}
\title{Network Adjusted Mean/Sum}
\usage{
nams(data, A, standardize = TRUE, adjusted = c("mean", "sum"),
  comm = c("walktrap", "louvain"), ...)
}
\arguments{
\item{data}{Must be a dataset}

\item{A}{Adjacency matrix that has already been filtered}

\item{standardize}{Should mean/sum scores be standardized?
Defaults to TRUE.
Set to FALSE for unstandardized mean/sum scores}

\item{adjusted}{Should adjusted values be the mean or sum score?
Defaults to "mean".
Set to "sum" for sum scores}

\item{comm}{Can be a vector of community assignments or community detection algorithms
("walktrap" or "louvain") can be used to determine the number of communities.
Defaults to 1 community.
Set to "walktrap" for the walktrap algortihm.
Set to "louvain" for louvain community detection}

\item{...}{Additional arguments for community detection algorithms}
}
\value{
Returns a list containing:

\item{NetAdjScore}{The network adjusted score}

\item{CommItems}{The items associated with the specified or identified communities}

\item{CommCor}{Correlations between the specified or identified communities}
}
\description{
The hybrid centrality is used to adjust the mean or sum score of participant's community scores based on each node's centrality.
Each participant's response values are multipled by the corresponding hybrid centrality value (uses "random" for BC argument).
In this way, more central nodes contribute a greater score and less central nodes contribute a lesser score
}
\examples{
A <- TMFG(neoOpen)$A

#one community
sumadj <- nams(neoOpen, A, adjusted = "sum")

#theoretical communities
knowncomm <- nams(neoOpen, A,
comm = c(rep(1,8),rep(2,8),rep(3,8),rep(4,8),rep(5,8),rep(6,8)))

#walktrap communities
walkadj <- nams(neoOpen, A, adjusted = "sum", comm = "walktrap")

}
\references{
Christensen, A. P. (2018).
NetworkToolbox: Methods and measures for brain, cognitive, and psychometric network analysis in R.
\emph{PsyArXiv}.
doi: \href{https://doi.org/10.31234/osf.io/6kmav}{10.31234/osf.io/6kmav}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
