% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoGo.R
\name{LoGo}
\alias{LoGo}
\title{Local/Global Inversion Method}
\usage{
LoGo(data, cliques, separators, normal = TRUE, na.data = c("pairwise",
  "listwise", "fiml", "none"), partial = TRUE, ...)
}
\arguments{
\item{data}{Must be a dataset}

\item{cliques}{Cliques defined in the network.
Input can be a list or matrix}

\item{separators}{Separators defined in the network.
Input can be a list or matrix}

\item{normal}{Should data be transformed to a normal distribution?
Defaults to \code{TRUE} (computes correlations using the \code{\link[qgraph]{cor_auto}} function).
Set to \code{FALSE} for Pearson's correlations}

\item{na.data}{How should missing data be handled?
For \code{"listwise"} deletion the \code{\link{na.omit}} function is applied.
Set to \code{"fiml"} for Full Information Maxmimum Likelihood (\code{\link[psych]{corFiml}}).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{partial}{Should the output network's connections be the partial correlation between two nodes given all other nodes?
Defaults to \code{TRUE}, which returns a partial correlation matrix.
Set to \code{FALSE} for a sparse inverse covariance matrix}

\item{...}{Additional arguments (deprecated arguments)}
}
\value{
Returns the sparse LoGo-filtered inverse covariance matrix (\code{partial = FALSE})
or LoGo-filtered partial correlation matrix (\code{partial = TRUE})
}
\description{
Applies the Local/Global method to estimate
a Gaussian Graphical Model (GGM) using a \code{\link[NetworkToolbox]{TMFG}}-filtered network
(\strong{see and cite Barfuss et al., 2016}). Also used to 
convert clique and separator structure from
\code{\link[NetworkToolbox]{MFCF}} into partial correlation
and precision matrices
}
\examples{
\dontrun{
LoGonet <- LoGo(neoOpen, partial = TRUE)
}

}
\references{
Barfuss, W., Massara, G. P., Di Matteo, T., & Aste, T. (2016).
Parsimonious modeling with information filtering networks.
\emph{Physical Review E}, \emph{94}, 062306.
doi: \href{https://doi.org/10.1103/PhysRevE.94.062306}{10.1103/PhysRevE.94.062306}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
