#' NetworkToolbox--package
#' @description Implements network analysis and graph theory measures used
#' in neuroscience, cognitive science, and psychology.
#' Methods include various filtering methods and approaches such as
#' threshold, dependency, Information Filtering Networks, and Efficiency-Cost Optimization.
#' Brain methods include the recently developed Connectome Predictive Modeling.
#' Also implements several network measures including local network characteristics
#' (e.g., centrality), global network characteristics (e.g., clustering coefficient),
#' and various other measures associated with the reliability and
#' reproducibility of network analysis. 
#' 
#' @references
#' Christensen, A. P. (in press).
#' NetworkToolbox: Methods and measures for brain, cognitive, and psychometric network analysis in R.
#' \emph{The R Journal}, 1-18.
#' doi: \href{https://doi.org/10.31234/osf.io/6kmav}{10.31234/osf.io/6kmav}
#' 
#' @author Alexander Christensen <alexpaulchristensen@gmail.com>
#' 
#' @importFrom utils packageDescription
#' 
"_PACKAGE"
#> [1] "_PACKAGE"
#NetworkToolbox----