% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/un.direct.R
\name{un.direct}
\alias{un.direct}
\title{Convert Directed Network to Undirected Network}
\usage{
un.direct(A, diagonal = 0)
}
\arguments{
\item{A}{Matrix or data frame.
Adjacency matrix (network matrix)}

\item{diagonal}{Numeric.
Number to be placed on the diagonal.
Defaults to \code{0}}
}
\value{
Returns a symmetric adjacency matrix
}
\description{
Converts a directed network to an undirected network
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

# create a directed network
dir <- A * sample(c(0,1), size = length(A), replace = TRUE)

# undirect the directed network
undir <- un.direct(dir)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
