<!-- rmarkdown v1 -->

NlsyLinks
================

| [GitHub](https://github.com/LiveOak/NlsyLinks) | [Travis-CI](https://travis-ci.org/LiveOak/NlsyLinks/builds) | [AppVeyor](https://ci.appveyor.com/project/wibeasley/nlsylinks/history) | [Wercker](https://app.wercker.com/#applications/5590d20a4fea05eb7a02e590) | [Coveralls](https://coveralls.io/r/LiveOak/NlsyLinks) | [Codecov](https://codecov.io/github/LiveOak/NlsyLinks)
| :----- | :---------------------------: | :------------: | :-------: | :-------: | :-------: | 
| [Master](https://github.com/LiveOak/NlsyLinks/tree/master) |  [![Travis-CI Build Status](https://travis-ci.org/LiveOak/NlsyLinks.png?branch=master)](https://travis-ci.org/LiveOak/NlsyLinks) | [![Build status](https://ci.appveyor.com/api/projects/status/fo1oeqn9734dhhmu/branch/master?svg=true)](https://ci.appveyor.com/project/wibeasley/nlsylinks/branch/master) | [![wercker status](https://app.wercker.com/status/928102b057451d7a43ebbacc13468de3/s "wercker status")](https://app.wercker.com/project/bykey/928102b057451d7a43ebbacc13468de3) |  [![Coverage Status](https://coveralls.io/repos/LiveOak/NlsyLinks/badge.svg?branch=master)](https://coveralls.io/r/LiveOak/NlsyLinks?branch=master) | [![codecov.io](http://codecov.io/github/LiveOak/NlsyLinks/coverage.svg?branch=master)](http://codecov.io/github/LiveOak/NlsyLinks?branch=master) | 
| [Dev](https://github.com/LiveOak/NlsyLinks/tree/dev) | [![Travis-CI Build Status](https://travis-ci.org/LiveOak/NlsyLinks.png?branch=dev)](https://travis-ci.org/LiveOak/NlsyLinks) | [![Build status](https://ci.appveyor.com/api/projects/status/fo1oeqn9734dhhmu/branch/dev?svg=true)](https://ci.appveyor.com/project/wibeasley/nlsylinks/branch/dev) | [![wercker status](https://app.wercker.com/status/928102b057451d7a43ebbacc13468de3/s/dev "wercker status")](https://app.wercker.com/project/bykey/928102b057451d7a43ebbacc13468de3) | [![Coverage Status](https://coveralls.io/repos/LiveOak/NlsyLinks/badge.svg?branch=dev)](https://coveralls.io/r/LiveOak/NlsyLinks?branch=dev) | [![codecov.io](http://codecov.io/github/LiveOak/NlsyLinks/coverage.svg?branch=dev)](http://codecov.io/github/LiveOak/NlsyLinks?branch=dev) |
| | *Ubuntu 12.04 LTS* | *Windows Server 2012* | *Docker* | *Travis Tests* | *Wercker Tests* |


Independently-hosted Archive: [![DOI](https://zenodo.org/badge/4971/LiveOak/NlsyLinks.png)](http://dx.doi.org/10.5281/zenodo.12519). 

## Description

Utilities and kinship information for behavior genetics and
developmental research using the National Longitudinal Survey of Youth
([NLSY](http://www.bls.gov/nls/))

## Installing 

The *release* version of `NlsyLinks` can be installed from [CRAN](http://cran.r-project.org/package=NlsyLinks).

```r
install.packages("NlsyLinks")
```

The latest *development* version of `NlsyLinks` can be installed from [GitHub](https://github.com/LiveOak/NlsyLinks/) after installing the `devtools` package.

```r
install.packages("devtools")
devtools::install_github(repo="LiveOak/NlsyLinks")
```

## Locations for Help and Development

This repository contains the code used in the [NlsyLinks]http://cran.r-project.org/package=NlsyLinks) R package.  For additional information about the package and using it in NLSY research, please see http://liveoak.github.io/NlsyLinks/

We now use  [this GitHub repository](https://github.com/LiveOak/NlsyLinksStaging) as our primary way of managing, tracking, and build-checking versions of the source code.  We continue to use the [R-Forge site](https://r-forge.r-project.org/projects/nlsylinks/) to make sure the most recent version builds on the different OS platforms, and passes the associated checks.  The stable releases (intended for most researchers) is available on the package's  [CRAN site](http://cran.r-project.org/web/packages/NlsyLinks/).

The help forums remain on the package's [R-Forge](https://r-forge.r-project.org/forum/?group_id=1330).  

## Thanks to Funders
The current work on the NLSY Kinship links has been supported by NIH Grant R01-HD065865 ([Joe Rodgers](http://www.vanderbilt.edu/psychological_sciences/bio/joe-rodgers), PI). 

