% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nematode.R
\name{ind_nematodes}
\alias{ind_nematodes}
\title{Calculate indicator for plant parasitic nematodes}
\usage{
ind_nematodes(
  B_LU_BRP = B_LU_BRP,
  A_RLN_PR_TOT = 0,
  A_RLN_PR_CREN = 0,
  A_RLN_PR_NEG = 0,
  A_RLN_PR_PEN = 0,
  A_RLN_PR_PRA = 0,
  A_RLN_PR_THO = 0,
  A_RLN_PR_FLA = 0,
  A_RLN_PR_FAL = 0,
  A_RLN_PR_PIN = 0,
  A_RLN_PR_PSE = 0,
  A_RLN_PR_VUL = 0,
  A_RLN_PR_DUN = 0,
  A_RLN_PR_ZEA = 0,
  A_RKN_ME_TOT = 0,
  A_RKN_ME_HAP = 0,
  A_RKN_ME_CHIFAL = 0,
  A_RKN_ME_CHI = 0,
  A_RKN_ME_NAA = 0,
  A_RKN_ME_FAL = 0,
  A_RKN_ME_MIN = 0,
  A_RKN_ME_INC = 0,
  A_RKN_ME_JAV = 0,
  A_RKN_ME_ART = 0,
  A_RKN_ME_ARE = 0,
  A_RKN_ME_ARD = 0,
  A_DSN_TR_TOT = 0,
  A_DSN_TR_SIM = 0,
  A_DSN_TR_PRI = 0,
  A_DSN_TR_VIR = 0,
  A_DSN_TR_SPA = 0,
  A_DSN_TR_CYL = 0,
  A_DSN_TR_HOO = 0,
  A_DSN_PA_TER = 0,
  A_DSN_PA_PAC = 0,
  A_DSN_PA_ANE = 0,
  A_DSN_PA_NAN = 0,
  A_DSN_TY_TOT = 0,
  A_DSN_RO_TOT = 0,
  A_DSN_XI_TOT = 0,
  A_DSN_LO_TOT = 0,
  A_DSN_HEM_TOT = 0,
  A_DSN_HEL_TOT = 0,
  A_SN_DI_TOT = 0,
  A_SN_DI_DIP = 0,
  A_SN_DI_DES = 0,
  A_OPN_PA_TOT = 0,
  A_OPN_PA_BUK = 0,
  A_OPN_CY_TOT = 0,
  A_OPN_AP_TOT = 0,
  A_OPN_AP_FRA = 0,
  A_OPN_AP_RIT = 0,
  A_OPN_AP_SUB = 0,
  A_OPN_CR_TOT = 0,
  A_OPN_SU_TOT = 0,
  A_NPN_SA_TOT = 0
)
}
\arguments{
\item{B_LU_BRP}{(numeric) The crop code (gewascode) from the BRP}

\item{A_RLN_PR_TOT}{(numeric) Number of pratylenchus spp. (n / 100g)}

\item{A_RLN_PR_CREN}{(numeric) Number of pratylenchus crenatus (n / 100g)}

\item{A_RLN_PR_NEG}{(numeric) Number of pratylenchus neglectus (n / 100g)}

\item{A_RLN_PR_PEN}{(numeric) Number of pratylenchus penetrans (n / 100g)}

\item{A_RLN_PR_PRA}{(numeric) Number of pratylenchus pratensis (n / 100g)}

\item{A_RLN_PR_THO}{(numeric) Number of pratylenchus thornei (n / 100g)}

\item{A_RLN_PR_FLA}{(numeric) Number of pratylenchus flakkensis (n / 100g)}

\item{A_RLN_PR_FAL}{(numeric) Number of pratylenchus fallax (n / 100g)}

\item{A_RLN_PR_PIN}{(numeric) Number of pratylenchus pinguicaudatus (n / 100g)}

\item{A_RLN_PR_PSE}{(numeric) Number of pratylenchus pseudopratensis (n / 100g)}

\item{A_RLN_PR_VUL}{(numeric) Number of pratylenchus vulnus (n / 100g)}

\item{A_RLN_PR_DUN}{(numeric) Number of pratylenchus dunensis (n / 100g)}

\item{A_RLN_PR_ZEA}{(numeric) Number of pratylenchus zeae (n / 100g)}

\item{A_RKN_ME_TOT}{(numeric) Number of meloidogyne spp. (n / 100g)}

\item{A_RKN_ME_HAP}{(numeric) Number of meloidogyne hapla (n / 100g)}

\item{A_RKN_ME_CHIFAL}{(numeric) Number of meloidogyne chitwoodi/fallax (n / 100g)}

\item{A_RKN_ME_CHI}{(numeric) Number of meloidogyne chitwoodi (n / 100g)}

\item{A_RKN_ME_NAA}{(numeric) Number of meloidogyne naasi (n / 100g)}

\item{A_RKN_ME_FAL}{(numeric) Number of meloidogyne fallax (n / 100g)}

\item{A_RKN_ME_MIN}{(numeric) Number of meloidogyne minor (n / 100g)}

\item{A_RKN_ME_INC}{(numeric) Number of meloidogyne incognita (n / 100g)}

\item{A_RKN_ME_JAV}{(numeric) Number of meloidogyne javanica (n / 100g)}

\item{A_RKN_ME_ART}{(numeric) Number of meloidogyne artiellia (n / 100g)}

\item{A_RKN_ME_ARE}{(numeric) Number of meloidogyne arenaria (n / 100g)}

\item{A_RKN_ME_ARD}{(numeric) Number of meloidogyne ardenensis (n / 100g)}

\item{A_DSN_TR_TOT}{(numeric) Number of trichodoridae spp. (n / 100g)}

\item{A_DSN_TR_SIM}{(numeric) Number of trichodorus similis (n / 100g)}

\item{A_DSN_TR_PRI}{(numeric) Number of trichodorus primitivus (n / 100g)}

\item{A_DSN_TR_VIR}{(numeric) Number of trichodorus viruliferus (n / 100g)}

\item{A_DSN_TR_SPA}{(numeric) Number of trichodorus sparsus (n / 100g)}

\item{A_DSN_TR_CYL}{(numeric) Number of trichodorus cylindricus (n / 100g)}

\item{A_DSN_TR_HOO}{(numeric) Number of trichodorus hooperi (n / 100g)}

\item{A_DSN_PA_TER}{(numeric) Number of paratrichodorus teres (n / 100g)}

\item{A_DSN_PA_PAC}{(numeric) Number of paratrichodorus pachydermus (n / 100g)}

\item{A_DSN_PA_ANE}{(numeric) Number of paratrichodorus anemones (n / 100g)}

\item{A_DSN_PA_NAN}{(numeric) Number of paratrichodorus nanus (n / 100g)}

\item{A_DSN_TY_TOT}{(numeric) Number of tylenchorhynchus spp. (n / 100g)}

\item{A_DSN_RO_TOT}{(numeric) Number of rotylenchus spp. (n / 100g)}

\item{A_DSN_XI_TOT}{(numeric) Number of xiphinema spp. (n / 100g)}

\item{A_DSN_LO_TOT}{(numeric) Number of longidorus spp. (n / 100g)}

\item{A_DSN_HEM_TOT}{(numeric) Number of hemicycliophora spp. (n / 100g)}

\item{A_DSN_HEL_TOT}{(numeric) Number of helicotylenchus spp. (n / 100g)}

\item{A_SN_DI_TOT}{(numeric) Number of ditylenchus spp. (n / 100g)}

\item{A_SN_DI_DIP}{(numeric) Number of ditylenchus dipsaci (n / 100g)}

\item{A_SN_DI_DES}{(numeric) Number of ditylenchus destructor (n / 100g)}

\item{A_OPN_PA_TOT}{(numeric) Number of paratylenchus spp. (n / 100g)}

\item{A_OPN_PA_BUK}{(numeric) Number of paratylenchus bukowinensis (n / 100g)}

\item{A_OPN_CY_TOT}{(numeric) Number of cysteaaltjes (n / 100g)}

\item{A_OPN_AP_TOT}{(numeric) Number of aphelenchoides spp. (n / 100g)}

\item{A_OPN_AP_FRA}{(numeric) Number of aphelenchoides fragariae (n / 100g)}

\item{A_OPN_AP_RIT}{(numeric) Number of aphelenchoides ritzemabosi (n / 100g)}

\item{A_OPN_AP_SUB}{(numeric) Number of aphelenchoides subtenuis (n / 100g)}

\item{A_OPN_CR_TOT}{(numeric) Number of criconematidae spp. (n / 100g)}

\item{A_OPN_SU_TOT}{(numeric) Number of subanguina spp. (n / 100g)}

\item{A_NPN_SA_TOT}{(numeric) Number of saprofage en overige (n / 100g)}
}
\value{
The evaluated score for the soil function for nematode community. A numeric value between 0 and 1.
}
\description{
This function calculates the indicator for the presence of plant parasitic nematodes. 
If input values are not given, the number is assumed to be zero.
}
\examples{
ind_nematodes(B_LU_BRP = 1019)
ind_nematodes(B_LU_BRP = 1019,A_RLN_PR_TOT = 250,A_RLN_PR_ZEA = 400,A_SN_DI_DIP = 5)

}
