% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateDistances.R
\name{estimateDistances}
\alias{estimateDistances}
\title{Estimate distances between oscillators}
\usage{
estimateDistances(odenet, equilibrium, distGround = c("combined",
  "individual", "fixed", c("A", "B", "123", "A")), optim.control = list())
}
\arguments{
\item{odenet}{[\code{ODEnetwork}]\cr
List of class \code{\link{ODEnetwork}}.}

\item{equilibrium}{[\code{numeric(n)}]\cr
The desired equilibrium positions of the oscillators.}

\item{distGround}{[\code{character(1)}] or [\code{character(n)}]\cr
\code{"combined"} estimates one value for all distances of the oscillators to the ground.
Optimisation starts from \code{median(equilibrium)}.\cr
\code{"individual"} estimates individual distance values for every oscillator.
Optimisation starts from \code{equilibrium}.\cr
\code{"fixed"} no estimation of the distances to the ground. 
Set to diagonal of distances matrix in \code{\link{ODEnetwork}}.\cr
\code{character(n)} specifies groups of oscillators which distances to the ground are 
estimated by the same value. Optimisation starts from \code{median(equilibrium)} of the 
specified groups.\cr
Default is \code{"combined"}}

\item{optim.control}{[\code{list()}]\cr
A list of control parameters for optim.
See \code{\link{optim}}.}
}
\value{
an extended list of class \code{\link{ODEnetwork}}.\cr
Matrix of distances is added or overwritten.
}
\description{
Estimates the distances between the oscillators of a \code{\link{ODEnetwork}}
from an equilibrium state.
}
\examples{
masses <- c(1, 1)
dampers <- diag(c(1, 1))
springs <- diag(c(1, 1))
springs[1, 2] <- 1
equilibrium <- c(1/3, 5/3)
odenet <- ODEnetwork(masses, dampers, springs)
estimateDistances(odenet, equilibrium)$distances
estimateDistances(odenet, equilibrium, distGround="individual")$distances
}
