% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createState.R
\name{createState}
\alias{createState}
\title{Creates starting State Vector}
\usage{
createState(odenet)
}
\arguments{
\item{odenet}{[\code{ODEnetwork}]\cr
List of class \code{\link{ODEnetwork}}.}
}
\value{
a named vector with assigned starting state
}
\description{
Creates a vector with the starting state of the given \code{\link{ODEnetwork}}.
}
\examples{
if (interactive()) {
  masses <- c(1, 2)
  dampers <- diag(c(0.1, 0.5))
  dampers[1, 2] <- 0.05
  springs <- diag(c(4, 10))
  springs[1, 2] <- 6
  odenet <- ODEnetwork(masses, dampers, springs)
  createState(odenet)
}
}
