% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterzationQueries.R
\name{getTargetBinaryFeatures}
\alias{getTargetBinaryFeatures}
\title{Extract aggregate statistics of binary feature analysis IDs of interest for targets}
\usage{
getTargetBinaryFeatures(
  connectionHandler,
  schema,
  cTablePrefix = "c_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetIds = NULL,
  outcomeIds = NULL,
  analysisIds = c(3)
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cTablePrefix}{The prefix used for the characterization results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}

\item{analysisIds}{The feature extraction analysis ID of interest (e.g., 201 is condition)}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseName the name of the database}
 \item{targetName the target cohort name}
 \item{targetId the target cohort unique identifier}
 \item{outcomeName the outcome name}
 \item{outcomeId the outcome unique identifier}
 \item{minPriorObservation the minimum required observation days prior to index for an entry}
 \item{outcomeWashoutDays patients with the outcome occurring within this number of days prior to index are excluded (NA means no exclusion)}
 \item{covariateId the id of the feature}
 \item{covariateName the name of the feature}
 \item{sumValue the number of target patients who have the feature value of 1 (minus those excluded due to having the outcome prior)}
 \item{rawSum the number of target patients who have the feature value of 1 (ignoring exclusions)}
 \item{rawAverage the fraction of target patients who have the feature value of 1 (ignoring exclusions)}
}
}
\description{
This function extracts the feature extraction results for targets corresponding to specified target and outcome cohorts.
}
\details{
Specify the connectionHandler, the schema and the target/outcome cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

tbf <- getTargetBinaryFeatures (
connectionHandler = connectionHandler, 
schema = 'main'
)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryCaseSeries}()},
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseBinaryFeatures}()},
\code{\link{getCaseContinuousFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCharacterizationDemographics}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallenge}()},
\code{\link{getIncidenceRates}()},
\code{\link{getTargetContinuousFeatures}()},
\code{\link{getTargetCounts}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotAgeDistributions}()},
\code{\link{plotSexDistributions}()}
}
\concept{Characterization}
