% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS_o2m.R
\name{o2m_stripped2}
\alias{o2m_stripped2}
\title{Perform O2-PLS with two-way orthogonal corrections}
\usage{
o2m_stripped2(X, Y, n, nx, ny, tol = 1e-10, max_iterations = 100)
}
\arguments{
\item{X}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{Y}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{n}{Integer. Number of joint PLS components. Must be positive!}

\item{nx}{Integer. Number of orthogonal components in \eqn{X}. Negative values are interpreted as 0}

\item{ny}{Integer. Number of orthogonal components in \eqn{Y}. Negative values are interpreted as 0}

\item{tol}{double. Threshold for power method iteration}

\item{max_iterations}{Integer, Maximum number of iterations for power method}
}
\value{
A list containing
   \item{Tt}{Joint \eqn{X} scores}
   \item{W.}{Joint \eqn{X} loadings}
   \item{U}{Joint \eqn{Y} scores}
   \item{C.}{Joint \eqn{Y} loadings}
   \item{P_Yosc.}{Orthogonal \eqn{X} loadings}
   \item{P_Xosc.}{Orthogonal \eqn{Y} loadings}
   \item{B_U}{Regression coefficient in \code{Tt} ~ \code{U}}
   \item{B_T.}{Regression coefficient in \code{U} ~ \code{Tt}}
   \item{H_TU}{Residuals in \code{Tt} in \code{Tt} ~ \code{U}}
   \item{H_UT}{Residuals in \code{U} in \code{U} ~ \code{Tt}}
}
\description{
NOTE THAT THIS FUNCTION DOES NOT CENTER NOR SCALES THE MATRICES! Any normalization you will have to do yourself. It is best practice to at least center the variables though.
A stripped version of O2PLS
}
\details{
If both \code{nx} and \code{ny} are zero, \code{o2m} is equivalent to PLS2 with orthonormal loadings.
This is a stripped implementation of O2PLS, using \code{\link{svd}}. For data analysis purposes, consider using \code{\link{o2m}}.
}
\seealso{
\code{\link{ssq}}, \code{\link{o2m}}, \code{\link{loocv}}, \code{\link{adjR2}}
}
\keyword{internal}
