% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseConceptCounts.R
\name{summariseConceptCounts}
\alias{summariseConceptCounts}
\title{Summarise code use in patient-level data}
\usage{
summariseConceptCounts(
  cdm,
  conceptId,
  countBy = c("record", "person"),
  concept = TRUE,
  year = FALSE,
  sex = FALSE,
  ageGroup = NULL
)
}
\arguments{
\item{cdm}{A cdm object}

\item{conceptId}{List of concept IDs to summarise.}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts}

\item{concept}{TRUE or FALSE. If TRUE code use will be summarised by concept.}

\item{year}{TRUE or FALSE. If TRUE code use will be summarised by year.}

\item{sex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{A list of ageGroup vectors of length two. Code use will be
thus summarised by age groups.}
}
\value{
A summarised_result object with results overall and, if specified, by
strata.
}
\description{
Summarise code use in patient-level data
}
\examples{
\donttest{

cdm <- mockOmopSketch()

cs <- list(sumatriptan = c(35604883, 35604879, 35604880, 35604884))

results <- summariseConceptCounts(cdm, conceptId = cs)

results

PatientProfiles::mockDisconnect(cdm)
}
}
