% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploadOMLStudy.R
\name{uploadOMLStudy}
\alias{uploadOMLStudy}
\title{Upload OpenML Study information.}
\usage{
uploadOMLStudy(x, confirm.upload = NULL, verbosity = NULL)
}
\arguments{
\item{x}{[[\code{\link{OMLStudy}}]\cr
Contains the study information that should be uploaded.}

\item{confirm.upload}{[\code{logical(1)}]\cr
Should the user be asked to confirm the upload?
Default is the setting from your config.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{OMLStudy}].
}
\description{
A OpenML study is a collection of OpenML objects.
If you create a study through the website \url{https://www.openml.org/new/study}, you can also specify an alias which can be used to access the study.
}
\seealso{
Other uploading functions: \code{\link{makeOMLStudy}},
  \code{\link{uploadOMLDataSet}},
  \code{\link{uploadOMLFlow}}, \code{\link{uploadOMLRun}}
}
\concept{uploading functions}
