% Generated by roxygen2 (4.0.2): do not edit by hand
\name{omxCheckWarning}
\alias{omxCheckWarning}
\title{Correct Warning Message Function}
\usage{
omxCheckWarning(expression, message)
}
\arguments{
\item{expression}{an R expression that produces a warning}

\item{message}{a character string with the desired warning message}
}
\description{
This function tests whether the correct warning message is thrown.
}
\details{
Arguments \sQuote{expression} and \sQuote{message} give the expression
that generates the warning and the message that is supposed to be generated, respectively.
}
\examples{
msg <- paste("Objective functions like mxFIMLObjective()",
		"have been deprecated in favor of expectation and fit functions.\\n",
		"Please use mxExpectationNormal(covariance= , means = , ...) instead,",
		"and add a call to mxFitFunctionML().",
		"See examples at help(mxExpectationNormal)")
foo <- omxCheckWarning(mxFIMLObjective('cov', 'mean'), msg)
}
\references{
The OpenMx User's guide can be found at http://openmx.psyc.virginia.edu/documentation.
}
\seealso{
\code{\link{omxCheckError}}
\code{\link{omxCheckWithinPercentError}},
\code{\link{omxCheckIdentical}}, \code{\link{omxCheckSetEquals}},
\code{\link{omxCheckTrue}}, \code{\link{omxCheckEquals}}
}

