% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampling.R
\name{grids_leave_n_out}
\alias{grids_leave_n_out}
\alias{grids_bootstrap}
\title{Resample constructs}
\usage{
grids_leave_n_out(x, n = 0)

grids_bootstrap(x, n = nrow(x), reps = 100, replace = TRUE)
}
\arguments{
\item{x}{A repgrid object.}

\item{n}{Number of constructs to drop or to sample in each generated grid.}

\item{reps}{Number of grids to generate.}

\item{replace}{Resample constructs with replacement?}
}
\value{
List of grids.
}
\description{
The goal of resampling is to build variations of a single grid. 
Two variants are implemented: The first is the \emph{leave-n-out} approach which 
builds all possible grids when dropping n constructs. The second is a 
\emph{bootstrap} approach, randomly drawing n constructs from the grid.
}
\examples{
## All results for PVAFF index when one construct is left out 
p <- indexPvaff(boeker)
l <- grids_leave_n_out(boeker, n = 1)
pp <- sapply(l, indexPvaff)  # apply indexPvaff function to all grids
range(pp)   # min and max PVAFF
hist(pp, xlab = "PVAFF values")    # visualize
abline(v = p, col = "blue", lty = 2)
}
