% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.r
\name{indexVariability}
\alias{indexVariability}
\title{Calculate 'variability' of a grid as defined by Slater (1977).}
\usage{
indexVariability(x, min = NULL, max = NULL, digits = 2)
}
\arguments{
\item{x}{\code{repgrid} object.}

\item{min, max}{Minimum and maximum grid scale values. Nor needed if they are set for the grid.}

\item{digits}{Numeric. Number of digits to round to (default is \code{2}).}
}
\value{
Numeric.
}
\description{
Variability records a tendency for the responses to gravitate towards both end of the gradings scale. (Slater, 1977,
p.88).
}
\note{
STATUS: working and checked against example in Slater, 1977 , p.88.
}
\examples{
indexVariability(boeker)

}
\references{
Slater, P. (1977). \emph{The measurement of intrapersonal space by Grid technique}. London: Wiley.
}
\seealso{
\code{\link[=indexBias]{indexBias()}}
}
