% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_res.R
\name{spec_res}
\alias{spec_res}
\alias{spec_res.default}
\alias{spec_res.OpenSpecy}
\title{Spectral resolution}
\usage{
spec_res(x, ...)

\method{spec_res}{default}(x, ...)

\method{spec_res}{OpenSpecy}(x, ...)
}
\arguments{
\item{x}{a numeric vector with \code{wavenumber} data or an \code{OpenSpecy}
object.}

\item{\ldots}{further arguments passed to subfunctions; currently not used.}
}
\value{
\code{spec_res()} returns a single numeric value.
}
\description{
Helper function for calculating the spectral resolution from
\code{wavenumber} data.
}
\details{
The spectral resolution is the the minimum wavenumber, wavelength, or
frequency difference between two lines in a spectrum that can still be
distinguished.
}
\examples{
data("raman_hdpe")

spec_res(raman_hdpe)

}
\author{
Win Cowger, Zacharias Steinmetz
}
