% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenSpecy-package.R
\docType{package}
\name{OpenSpecy-package}
\alias{OpenSpecy-package}
\alias{openspecy}
\title{OpenSpecy: Analyze, Process, Identify, and Share Raman and (FT)IR Spectra}
\description{
Raman and (FT)IR spectral analysis tool for plastic particles and other environmental samples (Cowger et al. 2021, \doi{10.1021/acs.analchem.1c00123}). With read_any(), Open Specy provides a single function for reading individual, batch, or map spectral data files like .asp, .csv, .jdx, .spc, .spa, .0, and .zip. process_spec() simplifies processing spectra, including smoothing, baseline correction, range restriction and flattening, intensity conversions, wavenumber alignment, and min-max normalization. Spectra can be identified in batch using an onboard reference library (Cowger et al. 2020, \doi{10.1177/0003702820929064}) using match_spec(). A Shiny app is available via run_app() or online at \url{https://openanalysis.org/openspecy/}.
}
\references{
Chabuka BK, Kalivas JH (2020). “Application of a Hybrid Fusion Classification
Process for Identification of Microplastics Based on Fourier Transform
Infrared Spectroscopy.” \emph{Applied Spectroscopy}, \strong{74}(9),
1167–1183. \doi{10.1177/0003702820923993}.

Cowger W, Gray A, Christiansen SH, De Frond H, Deshpande AD, Hemabessiere L,
Lee E, Mill L, et al. (2020). “Critical Review of Processing and
Classification Techniques for Images and Spectra in Microplastic Research.”
\emph{Applied Spectroscopy}, \strong{74}(9), 989–1010.
\doi{10.1177/0003702820929064}.

Cowger, W (2023). “Library data.” \emph{OSF}. \doi{10.17605/OSF.IO/X7DPZ}.

Cowger W, Steinmetz Z, Gray A, Munno K, Lynch J, Hapich H, Primpke S,
De Frond H, Rochman C, Herodotou O (2021). “Microplastic Spectral
Classification Needs an Open Source Community: Open Specy to the Rescue!”
\emph{Analytical Chemistry}, \strong{93}(21), 7543–7548.
\doi{10.1021/acs.analchem.1c00123}.

Primpke S, Wirth M, Lorenz C, Gerdts G (2018). “Reference Database Design
for the Automated Analysis of Microplastic Samples Based on Fourier
Transform Infrared (FTIR) Spectroscopy.” \emph{Analytical and Bioanalytical
Chemistry}, \strong{410}(21), 5131–5141. \doi{10.1007/s00216-018-1156-x}.

Savitzky A, Golay MJ (1964). “Smoothing and Differentiation of Data by
Simplified Least Squares Procedures.” \emph{Analytical Chemistry},
\strong{36}(8), 1627--1639.

Zhao J, Lui H, McLean DI, Zeng H (2007). “Automated Autofluorescence
Background Subtraction Algorithm for Biomedical Raman Spectroscopy.”
\emph{Applied Spectroscopy}, \strong{61}(11), 1225–1232.
\doi{10.1366/000370207782597003}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/wincowgerDEV/OpenSpecy-package/}
  \item \url{https://wincowger.com/OpenSpecy-package/}
  \item Report bugs at \url{https://github.com/wincowgerDEV/OpenSpecy-package/issues/}
}

}
\author{
\strong{Maintainer}: Win Cowger \email{wincowger@gmail.com} (\href{https://orcid.org/0000-0001-9226-3104}{ORCID}) [data contributor]

Authors:
\itemize{
  \item Zacharias Steinmetz \email{z.steinmetz@rptu.de} (\href{https://orcid.org/0000-0001-6675-5033}{ORCID})
  \item Hazel Vaquero \email{hvaquero98@gmail.com} (\href{https://orcid.org/0009-0001-5468-2049}{ORCID})
  \item Nick Leong (\href{https://orcid.org/0009-0008-3313-4132}{ORCID})
  \item Andrea Faltynkova (\href{https://orcid.org/0000-0003-2523-3137}{ORCID}) [data contributor]
  \item Hannah Sherrod (\href{https://orcid.org/0009-0001-0497-8693}{ORCID})
}

Other contributors:
\itemize{
  \item Andrew B Gray (\href{https://orcid.org/0000-0003-2252-7367}{ORCID}) [contributor]
  \item Hannah Hapich (\href{https://orcid.org/0000-0003-0000-6632}{ORCID}) [contributor]
  \item Jennifer Lynch (\href{https://orcid.org/0000-0003-3572-8782}{ORCID}) [contributor, data contributor]
  \item Hannah De Frond (\href{https://orcid.org/0000-0003-1199-0727}{ORCID}) [contributor, data contributor]
  \item Keenan Munno (\href{https://orcid.org/0000-0003-2916-5944}{ORCID}) [contributor, data contributor]
  \item Chelsea Rochman (\href{https://orcid.org/0000-0002-7624-711X}{ORCID}) [contributor, data contributor]
  \item Sebastian Primpke (\href{https://orcid.org/0000-0001-7633-8524}{ORCID}) [contributor, data contributor]
  \item Orestis Herodotou [contributor]
  \item Mary C Norris [contributor]
  \item Christine M Knauss (\href{https://orcid.org/0000-0003-4404-8922}{ORCID}) [contributor]
  \item Aleksandra Karapetrova (\href{https://orcid.org/0000-0002-9856-1644}{ORCID}) [contributor, data contributor, reviewer]
  \item Vesna Teofilovic (\href{https://orcid.org/0000-0002-3557-1482}{ORCID}) [contributor]
  \item Laura A. T. Markley (\href{https://orcid.org/0000-0003-0620-8366}{ORCID}) [contributor]
  \item Shreyas Patankar [contributor, data contributor]
  \item Rachel Kozloski (\href{https://orcid.org/0000-0003-1211-9351}{ORCID}) [contributor, data contributor]
  \item Samiksha Singh [contributor]
  \item Katherine Lasdin [contributor]
  \item Cristiane Vidal (\href{https://orcid.org/0000-0001-6363-9475}{ORCID}) [contributor]
  \item Clare Murphy-Hagan (\href{https://orcid.org/0009-0009-9629-2856}{ORCID}) [contributor]
  \item Philipp Baumann \email{info@spectral-cockpit.space} (\href{https://orcid.org/0000-0002-3194-8975}{ORCID}) [contributor]
  \item Pierre Roudier [contributor]
  \item National Renewable Energy Laboratory [funder]
  \item Possibility Lab [funder]
}

}
\keyword{internal}
