% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readoqcsv.R
\name{readoqcsv}
\alias{readoqcsv}
\title{Read OptiQuant's exported .csv file.}
\usage{
readoqcsv(x)
}
\arguments{
\item{x}{Single string. Name / path of the file to read in. See details.}
}
\value{
Classes ‘data.table’ and 'data.frame':	n obs. of  17 variables:

Where n is the number of rows no the csv file - 1.

Names of variables (columns): "timeStampO", "session_id", "session_started",
"session_finished", "session_total_counted", "gate_id", "person_kind", "id",
"year", "month", "day", "weekday", "hour", "week", "min_start_off",
"session_length", "timeStamp"
}
\description{
\code{readoqcsv} returns a keyed data.table and data.frame ready for fast and
easy analysis and reporting.
}
\details{
Optimized for speed and preparation of data for custom analysis through simple
user input. Reads in .csv eliminating unnecessary columns. Sets column classes
as appropriate for subsequent use in analysis and reporting. Based on the data
imported, it creates new columns to facilitate simple user input for
customizing the analysis. Also creates column to facilitate the simple
inclusion of a margin of error when filtering data.

readoqcsv("/Users/jpinelo/JPLab/R Projects/opti_557d819b88209.csv")
Note that full path is necessary when the file is not in the current working
directory.

readoqcsv("opti_557d819b88209.csv")
Note that when file is in current working directory, the name and extension of
the file are enough.
}
\examples{
readoqcsv(system.file("extdata", "testdata.csv", package = "OptiQuantR"))
}

