% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_overlap.R
\name{community_overlap}
\alias{community_overlap}
\title{Community Overlap Calculation}
\usage{
community_overlap(
  traits,
  sp,
  discrete = FALSE,
  circular = FALSE,
  normal = TRUE,
  output = "median",
  weight_type = "hmean",
  randomize_weights = FALSE,
  unique_values = NULL,
  raw = FALSE,
  circular_args = list(),
  density_args = list(),
  hypervolume_set_args = list()
)
}
\arguments{
\item{traits}{a vector of trait measurements in the univariate case, or a
matrix in the multivariate case where each column is a trait.}

\item{sp}{a vector with length equal to length(traits) that indicates the
taxon of each individual.}

\item{discrete}{whether trait data may take continuous or discrete values. Defaults to
\code{FALSE} (all traits continuous). A single logical value or a logical
vector with length equal to the number of columns in traits.}

\item{circular}{whether trait data are circular (e.g., hours or angles). Defaults to
\code{FALSE} (all traits non-circular). A single logical value or a logical
vector with length equal to the number of columns in traits.}

\item{normal}{if TRUE, the area under all density functions is normalized to 1,
if FALSE, the area under all density functions is proportional to the number of
observations in that group.}

\item{output}{specifies whether median or mean is calculated.}

\item{weight_type}{specifies weights to be used to calculate the median or mean.}

\item{randomize_weights}{If TRUE, randomize weights given to pairwise overlaps
within a community. This can be used to generate null models.}

\item{unique_values}{Vector of all possible discrete values that \code{traits}
can take. Only used if \code{discrete = TRUE} and \code{circular = TRUE}.}

\item{raw}{If \code{TRUE}, also return the raw individual pairwise overlaps
used to calculate the community-level statistic. Default is \code{FALSE}.}

\item{circular_args}{optional list of additional arguments to pass to
\code{\link[circular]{circular}}. Only used if \code{circular = TRUE} and
\code{discrete = FALSE}.}

\item{density_args}{list of additional arguments to be passed to
\code{\link[stats]{density}} if univariate, or
\code{\link[hypervolume]{hypervolume}} if multivariate.}

\item{hypervolume_set_args}{list of additional arguments to be passed to
\code{\link[hypervolume]{hypervolume_set}}. Used only in multivariate case.}
}
\value{
The function returns the O-statistic for the community as a numeric value. If
\code{raw = TRUE}, instead a list is returned, where the first element \code{value} is
the numeric value, and the second element \code{raw} is a data frame with all the raw
pairwise overlaps.
}
\description{
This function calculates the median or mean of pairwise overlaps between density
estimates of trait distributions of all species within a community, which can
be weighted by species abundances.
}
\details{
The function evaluates weighted mean or median of overlaps of density
estimates of all species in a community taking complete cases with species abundances
greater than 1 from the dataset. The default calculates the median of pairwise overlaps
for the whole community using the harmonic means of abundances of the species pairs as
weights, which minimizes the effect of outliners and rare species.If the argument
\code{weight_type = "none"}, no weights are used for the calculation of mean/median. If
\code{weight_type = "mean"}, arithmetic means of abundances are used as weights. To change the
output to mean, specify the argument \code{output = "mean"}.
}
\examples{
library(Ostats)

# Keep only the relevant part of small mammal data
dat <- small_mammal_data[small_mammal_data$siteID \%in\% c('HARV','JORN'), ]
dat <- dat[!is.na(dat$weight), ]
dat$log_weight <- log10(dat$weight)

# Calculate median of pairwise overlaps for the community,weighted by harmonic means
# of abundances
community_overlap(traits = as.matrix(dat$log_weight),
   sp = factor(dat$taxonID))

}
\references{
Read, Q. D. et al. Among-species overlap in rodent body size
  distributions predicts species richness along a temperature gradient.
  Ecography 41, 1718-1727 (2018).
}
