% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateIntervals.R
\name{estimateIntervals}
\alias{estimateIntervals}
\title{Function to estimate temporal changes in isotopic values}
\usage{
estimateIntervals(renewalRates, timeVars, boneVars = NULL, isoMean,
  isoSigma, mu_df = 1, mu_mean = 0, mu_sd = 10, rho_mean = 1,
  rho_sd = 0.25, alpha_mean = 2, alpha_sd = 0.5, mc = TRUE,
  adapt_delta = 0.9999, max_treedepth = 25, chains = 4,
  iter = 2000, ...)
}
\arguments{
\item{renewalRates}{A dataframe specifying the renewal rates of different probes for
each time interval. The renewalRates should be between 0 and 100 (percentages). The dataframe should include a column specifying a time-index (e.g. 1, 2, 3, ...)
as well as columns for the different bones. The renewal rates should contain the times of origin,
containing 100.}

\item{timeVars}{A character string specifying the name of the column indicating the time.}

\item{boneVars}{A vector of character strings indicating the relevant variables containing the
renewal rates of bones and teeth. If not given, the variables with bones are all variables of the dataframe apart from the time variables.}

\item{isoMean}{A numeric number indicating the mean of the isotopic values measured.}

\item{isoSigma}{A numeric, positive number indicating the standard deviation of the isotopic values measured.}

\item{mu_df}{Hyperparameter for the mean of the interval estimates: degrees of freedom of a non-standardized t-Student distribution. Defaults to 1.}

\item{mu_mean}{Hyperparameter for the mean of the interval estimates: mean of a non-standardized t-Student distribution. Defaults to 0.}

\item{mu_sd}{Hyperparameter for the mean of the interval estimates: standard deviation of a non-standardized t-Student distribution. Defaults to 10.}

\item{rho_mean}{Hyperparameter for the length scale of the rbf-kernel: mean of a normal. Defaults to 1.}

\item{rho_sd}{Hyperparameter for the length scale of the rbf-kernel: standard deviation of a normal. Defaults to 0.25.}

\item{alpha_mean}{Hyperparameter for the signal variance of the rbf-kernel: mean of a normal. Defaults to 2.}

\item{alpha_sd}{Hyperparameter for the signal variance of the rbf-kernel: standard deviation of a normal. Defaults to 0.5.}

\item{mc}{A boolean indicating if multiple cores should be used. If \code{TRUE}, which is the default, 4 cores are used.}

\item{adapt_delta}{A numeric value between 0 and 1 controlling the samplers behavior. Defaults to 0.9999. See \code{\link[rstan]{stan}} for more details.}

\item{max_treedepth}{A numeric, positive value controling the NUTS sampler. Defaults to 25. See \code{\link[rstan]{stan}} for more details.}

\item{chains}{Number of chains for mcmc. Defaults to 4}

\item{iter}{Number of iterations per chain for mcmc. Defaults to 2000}

\item{...}{Arguments passed to rstand \link[rstan]{sampling}}
}
\value{
A fitted object of class \link{TemporalIso}.
}
\description{
Given renewal rates for different isotopic probes over time, a model
estimates a normal distribution of the isotopic values for each time interval. Out of
the given rates of renewal, first the influence of each time interval on the final
isotopic value is calculated. This proportion is used as a regressor in a fully Bayesian
linear model. The variance is estimated as rbf-Kernel-Matrix, where the hyperparameters are
chosen such that the correlation between time intervals close to each other is about 0.5.
The estimation is implemented using \code{link[rstan]{rstan}}.
}
\examples{
\dontrun{
data <- data.frame(
intStart = 0:5,
intEnd = 1:6,
bone1 = c(100, 50, 20, 10, 5, 2),
bone2 = c(100, 10, 5, 1, 1, 1),
tooth1 = c(0, 100, 0, 0, 0, 0),
tooth2 = c(0, 0, 100, 0, 0, 0)
)
y_mean <- c(-10, -7, -12, -9)
y_sigma <- c(2, 1.5, 2.5, 2.5)
fit <- estimateIntervals(renewalRates = data,
                         timeVars = "intStart",
                         boneVars = c("bone1", "bone2", "tooth1", "tooth2"),
                         isoMean = y_mean,
                         isoSigma = y_sigma)
print(fit)
plot(fit)
plotTime(fit)

# get estimates for specific time points
estimateTimePoint(fit, time = seq(0,5, by = 0.5))

# shift point estimation
plotTime(fit, plotShifts = TRUE, threshold = 0.5)
getShiftTime(fit, threshold = 0.5)

#Staying time estimation
estimatedStayTimes <- getSiteStayTimes(object = fit,
siteMeans = c(-8, -10),
siteSigma = c(1, 1.5))
}

}
\seealso{
\link[rstan]{sampling}
}
