% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relacion_hm_gt.R
\name{relation_hm_gt}
\alias{relation_hm_gt}
\title{Ratios Hm/(Hm+Gt)}
\usage{
relation_hm_gt(
  data = data,
  points_smoothing = 0.3,
  hm_gt_limits = list(hm = c(535, 585), gt = c(430, 460)),
  pv_tolerance = c(1, 1, 1, 1),
  name_wave = "wave",
  plot = FALSE
)
}
\arguments{
\item{data}{A data.frame containing the input data, where the first column should be the wavelength and the remaining columns should contain the reflectance data of the sample.}

\item{points_smoothing}{The number of points used for smoothing the data to reduce noise in the spectral readings. The default value is 0.3.}

\item{hm_gt_limits}{A list containing the detection range values for hematite (hm) and goethite (gt). The default is \code{list(hem = c(535, 585), gt = c(430, 460))}.}

\item{pv_tolerance}{A numeric vector with 4 elements, each corresponding to one of the limits for hematite (hm) and goethite (gt). This value specifies the tolerance for the point values in the calculation, helping to account for small variations in the data and controlling the precision of the calculation.}

\item{name_wave}{The name of the wavelength column in the data. By default, it is set to 'wave'.}

\item{plot}{A logical value indicating whether to generate a plot of the results. If set to TRUE, a plot will be displayed; if FALSE, no plot will be shown.}
}
\value{
a \code{data.frame} with each sample in the rows and columns containing the minimum, maximum, and amplitude for Hm and Gt, along with the Hm/Gt ratio.
}
\description{
Calculates the relationship between the iron oxides hematite and goethite in soil sample: \deqn{Hm/Gt = \frac{\text{hematite}}{\text{hematite} + \text{goethite}}}
based on the soil's diffuse reflectance curve in the visible spectrum, the Kubelka-Munk equation, and the second derivative (Scheinost et al., 1998; Torrent et al., 2008).
}
\examples{
# example code
library(OxSR)
data(data_cary)

data_clean <- clean_sheet_cary(data_cary, prefix = "x")

relation_hm_gt(data_clean)

# With plot
relation_hm_gt(data_clean[,1:2], plot = TRUE)

}
\references{
Scheinost, A. C., Chavernas, A., Barrón, V., & Torrent, J. (1998).
Use and limitations of second-derivative diffuse reflectance spectroscopy in the visible to near-infrared range to identify and quantify Fe oxide minerals in soil. \emph{Clays and Clay Minerals, 46(5), 528–536.} \doi{10.1346/CCMN.1998.0460506}

Torrent, J., & Barron, V. (2008).
Diffuse Reflectance Spectroscopy. \emph{Methods of Soil Analysis, 5, 367–385.} \doi{10.2136/sssabookser5.5.c13}
}
