% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPresBar.R
\name{plotPresBar}
\alias{plotPresBar}
\title{plotPresBar}
\usage{
plotPresBar(
  x,
  start = NULL,
  end = NULL,
  bin = "hour/day",
  by = NULL,
  title = TRUE,
  fill = "grey35",
  format = c("\%m/\%d/\%Y \%H:\%M:\%S", "\%m-\%d-\%Y \%H:\%M:\%S",
    "\%Y/\%m/\%d \%H:\%M:\%S", "\%Y-\%m-\%d \%H:\%M:\%S"),
  plotTz = "UTC"
)
}
\arguments{
\item{x}{a data.frame of detections, must have a column \code{UTC} that contains the
time of detection as a POSIXct object in UTC timezone}

\item{start}{the beginning datetime of the plot, if \code{NULL} will be set to the minimum
time in \code{x}}

\item{end}{the ending datetime of the plot, if \code{NULL} will be set to the maximum
time in \code{x}}

\item{bin}{string identifying how to bin detections. Acceptable time units are
\code{c('minute', 'hour', 'day', 'week', 'month')}. For presence, \code{bin}
should be of the form \code{'unit1/unit2'}, e.g. \code{'hour/day'} will show
the hours per day with detections. For call density, \code{bin} is a single
time unit, e.g. \code{'hour'} will show the number of calls per hour. Call
density can also be specified as \code{'call/hour'}. Note that plural forms
of all units are accepted.}

\item{by}{(optional) if not \code{NULL}, specifies the name of a column in \code{x} to split and
color the bars by}

\item{title}{if \code{TRUE}, a title will automatically created. If any other value, that will be
used for the title of the plot.}

\item{fill}{the fill color for the bars, only used if \code{by} is \code{NULL}, otherwise bars are
colored by species using the default \link{ggplot2} palette}

\item{format}{date format if \code{UTC} column of \code{x} is a character}

\item{plotTz}{the timezone to use for plotting the data. Note that inputs must still be in UTC,
this option allows you to create plots scaled to local time. Valid values come from
\link{OlsonNames}}
}
\value{
a ggplot2 object
}
\description{
Creates a bar plot of the presence or density of detections across time
}
\examples{

df <- data.frame(UTC = as.POSIXct(runif(1e2, min=0, max=7*24*3600),
                                  origin='1970-01-01 00:00:00', tz='UTC'),
                 label = sample(letters[1:3], 1e2, replace=TRUE))
# hours per day with detections
plotPresBar(df, bin='hour/day')
# calls per day - these options are identical
plotPresBar(df, bin='day')
plotPresBar(df, bin='call/day')
plotPresBar(df, bin='calls/day')
# calls per day, colored by 'label'
plotPresBar(df, bin='day', by='label')

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
