% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/segmentVOL.R
\name{segmentVOL}
\alias{segmentVOL}
\title{Segment Multivariate Volatility Processes}
\usage{
segmentVOL(Y, k0)
}
\arguments{
\item{Y}{a data matrix with \eqn{n} rows and \eqn{p} columns, where \eqn{n} is the sample size and \eqn{p} is the dimension of the time series.}

\item{k0}{a positive integer specified to calculate Wy.}
}
\value{
An object of class "segmentVOL" is a list containing the following components:
\item{B}{the \eqn{p} by \eqn{p} transformation matrix such that {x_t}=B{y_t}}
\item{X}{the transformed series with \eqn{n} rows and \eqn{p} columns}
}
\description{
Calculate linear transformation of the \eqn{p}-variate volatility processes {y_t} such that the transformed volatility process {x_t}=B{y_t} can be segmented into \eqn{q} lower-dimensional processes, and there exist no \emph{conditional} cross correlations across those \eqn{q} processes.
}
\examples{
## Example 7 of Chang et al.(2014)
## Segmenting the returns of the 6 stocks

require(tseries)
data(returns)
Y=returns
n=dim(Y)[1]; p=dim(Y)[2]
# Carry out the transformation procedure
Trans=segmentVOL(Y,5)
X_0=data.frame(Trans$X)
X_1=X_0
# The ACF plot of the residuals after prewhitening the transformed data by GARCH(1,1)
nanum=rep(0,p)
for(j in 1:p) {options( warn = -1 )
               t=garch(X_1[,j], order = c(1,1),trace=FALSE)
               X_1[,j]=t$residuals
               a=X_1[,j]
               nanum[j]=length(a[is.na(X_1[,j])]) }
X=X_1[(max(nanum)+1):n,]
colnames(X)=c("X1","X2","X3","X4","X5","X6")
t=acf(X,plot=FALSE)
plot(t, max.mfrow=6, xlab='', ylab='',  mar=c(1.8,1.3,1.6,0.5),
    oma=c(1,1.2,1.2,1), mgp=c(0.8,0.4,0),cex.main=1.0,ylim=c(0,1))
# Identify the permutation mechanism
permutation=permutationMax(X_0,Vol=TRUE)
permutation$Groups
options( warn = 0)
}
\author{
Jinyuan Chang, Bin Guo and Qiwei Yao
}
\references{
Chang, J., Guo, B. and Yao, Q. (2014).  \emph{Segmenting Multiple Time Series by Contemporaneous Linear Transformation: PCA for Time Series}. Available at \url{http://arxiv.org/abs/1410.2323}.
}
\seealso{
\code{\link{segmentTS}}
}

