% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{TruePositiveRate}
\alias{TruePositiveRate}
\alias{FalsePositiveRate}
\title{True positive rate of a set of binary predictions against their trues}
\usage{
TruePositiveRate(pred, true)

FalsePositiveRate(pred, true)
}
\arguments{
\item{pred, true}{vectors of the same positive length that can be converted to
logical.}
}
\value{
a double between 0 and 1 or \code{NA_real_} if the result is not a
finite number.
}
\description{
Let the set of predictions be described by a logical vector
`pred`, and let the corresponding trues by described in a logical vector
`true` of the same length. Then, the true positive rate is given by the
expression:
\code{sum(pred & true)/sum(true)}. The false positive rate is given by the
expression:
\code{sum(pred & !true)/sum(!true)}. If these expressions do not give a
finite number, \code{NA_real_} is returned.
}
\examples{
TruePositiveRate(c(1,0,1,1), c(1,1,0,1))
TruePositiveRate(c(0,0,0,0), c(1,1,0,1))
TruePositiveRate(c(1,1,1,1), c(1,1,0,1))
FalsePositiveRate(c(1,0,1,1), c(1,1,0,1))
FalsePositiveRate(c(0,0,0,0), c(1,1,0,1))
FalsePositiveRate(c(1,1,1,1), c(1,1,0,1))
TruePositiveRate(c(1,0,1,1), c(0,0,0,0))
FalsePositiveRate(c(1,0,1,1), c(1,1,1,1))
}
