% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLSandRobustSFM.R
\name{plotLSandRobustSFM}
\alias{plotLSandRobustSFM}
\title{Robust and Least Square Single Factor Model (SFM) Fits}
\usage{
plotLSandRobustSFM(
  x,
  family = "mopt",
  efficiency = 0.95,
  mainText = NULL,
  ylimits = NULL,
  legendPos = "topleft",
  makePct = FALSE
)
}
\arguments{
\item{x}{A univariate xts object.}

\item{family}{Robust loss function choice with default mopt}

\item{efficiency}{Estimator Normal distribution efficiency, default 0.95}

\item{mainText}{Main title, if any.}

\item{ylimits}{Vertical axis limits.}

\item{legendPos}{Legend position.}

\item{makePct}{Logical variable with default FALSE}
}
\value{
No value returned, instead plot with straight line fits and legend
is displayed
}
\description{
Plot of Least squares and robust single factor model (SFM) fits,
with outliers identified, and legend containing slope and intercept coefficient
estimates with standard errors in parentheses.
}
\details{
The robust fit is computed using the lmrobdetMM() function in the
R package RobStatTM. For other choices of efficiency and family see the
RobStatTM package help(lmrobdetMM)
}
\examples{
args(plotLSandRobustSFM)
}
