% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PS.R
\name{PenS}
\alias{PenS}
\title{Penalized B-splines Regression Model}
\usage{
PenS(Y, X, alpha, M, d, domain)
}
\arguments{
\item{Y}{Vector of length n.}

\item{X}{Matrix of n x p, covariate matrix, should be dense.}

\item{alpha}{Vector.}

\item{M}{Integer, t1,..., tM are M equally spaced knots.}

\item{d}{Integer, the degree of B-Splines.}

\item{domain}{The range over which the function X(t) is evaluated and the coefficient function \eqn{\beta}(t) is expanded by the B-spline basis functions.}
}
\value{
beta: Estimated \eqn{\beta}(t) at discrete points.

extra: List containing other values which may be of use:
               \itemize{
                 \item b: Estimated B-spline coefficients.
                 \item Ymean: Mean of the Y values.
                 \item Xmean: Mean of all X values.
                 \item Optalpha: Optimal alpha value chosen.
                 \item M: Integer representing the number of knots used in the model calculation.
                 \item d: Integer, degree of B-Splines used.
                 \item domain: The range over which the function X(t) was evaluated and the coefficient function \eqn{\beta}(t) was expanded by the B-spline basis functions.
               }
}
\description{
Calculates a functional regression model using the penalized B-splines method.
}
\examples{
library(fda)
betaind = 1
snr  = 2
nsim = 1
n    = 50
p    = 21
Y = array(NA,c(n,nsim))
X = array(NA,c(n,p,nsim))
domain = c(0,1)

M = 20
d = 3
alpha = 10^(-(10:3))


for(itersim in 1:nsim)
{
dat = ngr.data.generator.bsplines(n=n,nknots=64,norder=4,p=p,domain=domain,snr=snr,betaind=betaind)
Y[,itersim]  = dat$Y
X[,,itersim] = dat$X
}

psfit = PenS(Y=Y[1:n,1],X=(X[1:n,,1]), alpha=alpha, M=M, d=d, domain=domain)



}
