% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/001-add.interval.col.R
\name{add.interval.col}
\alias{add.interval.col}
\title{Add columns for calculations within PKNCA intervals}
\usage{
add.interval.col(name, FUN, values = c(FALSE, TRUE), depends = c(),
  desc = "", formalsmap = list(), datatype = c("interval", "individual",
  "population"))
}
\arguments{
\item{name}{The column name as a character string}

\item{FUN}{The function to run (as a character string) or \code{NA}
if the parameter is automatically calculated when calculating
another parameter.}

\item{values}{Valid values for the column}

\item{depends}{Character vector of columns that must be run before
this column.}

\item{desc}{A human-readable description of the parameter (<=40
characters to comply with SDTM)}

\item{formalsmap}{A named list mapping parameter names in the
function call to NCA parameter names.  See the details for information on use of \code{formalsmap}.}

\item{datatype}{The type of data used for the calculation}
}
\value{
NULL (Calling this function has a side effect of
  changing the available intervals for calculations)
}
\description{
Add columns for calculations within PKNCA intervals
}
\details{
The \code{formalsmap} argument enables mapping some alternate formal
argument names to parameters.  It is used to generalize functions
that may use multiple similar arguments (such as the variants of mean
residence time). The names of the list should correspond to function
formal parameter names and the values should be one of the following:

\itemize{
  \item{For the current interval:}
  \describe{
    \item{character strings of NCA parameter name}{The value of the parameter calculated for the current interval.}
    \item{"conc"}{Concentration measurements for the current interval.}
    \item{"time"}{Times associated with concentration measurements for the current interval (values start at 0 at the beginning of the current interval).}
    \item{"volume"}{Volume associated with concentration measurements for the current interval (typically applies for excretion parameters like urine).}
    \item{"duration.conc"}{Durations assocuated with concentration measurements for the current interval.}
    \item{"dose"}{Dose amounts assocuated with the current interval.}
    \item{"time.dose"}{Time of dose start associated with the current interval (values start at 0 at the beginning of the current interval).}
    \item{"duration.dose"}{Duration of dose (typically infusion duration) for doses in the current interval.}
    \item{"route"}{Route of dosing for the current interval.}
    \item{"start"}{Time of interval start.}
    \item{"end"}{Time of interval end.}
    \item{"options"}{PKNCA.options governing calculations.}
  }
  \item{For the current group:}
  \describe{
    \item{"conc.group"}{Concentration measurements for the current group.}
    \item{"time.group"}{Times associated with concentration measurements for the current group (values start at 0 at the beginning of the current interval).}
    \item{"volume.group"}{Volume associated with concentration measurements for the current interval (typically applies for excretion parameters like urine).}
    \item{"duration.conc.group"}{Durations assocuated with concentration measurements for the current group.}
    \item{"dose.group"}{Dose amounts assocuated with the current group.}
    \item{"time.dose.group"}{Time of dose start associated with the current group (values start at 0 at the beginning of the current interval).}
    \item{"duration.dose.group"}{Duration of dose (typically infusion duration) for doses in the current group.}
    \item{"route.group"}{Route of dosing for the current group.}
  }
}
}
\examples{
\dontrun{
add.interval.col("cmax",
                 FUN="pk.calc.cmax",
                 values=c(FALSE, TRUE),
                 desc="Maximum observed concentration",
                 depends=c())
add.interval.col("cmax.dn",
                 FUN="pk.calc.dn",
                 values=c(FALSE, TRUE),
                 desc="Maximum observed concentration, dose normalized",
                 formalsmap=list(parameter="cmax"),
                 depends=c("cmax"))
}
}
