% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunking.R
\name{ids_per_plot}
\alias{ids_per_plot}
\alias{chunk}
\alias{chunk_grp}
\alias{chunk_list}
\alias{chunk_grp_list}
\title{split IDs into groups to use for subsequent plotting}
\usage{
ids_per_plot(id, id_per_plot = 9)

chunk(.x, .nchunk = parallel::detectCores())

chunk_grp(.x, .nchunk = parallel::detectCores())

chunk_list(.x, .nchunk = parallel::detectCores())

chunk_grp_list(.x, .nchunk = parallel::detectCores())
}
\arguments{
\item{id}{vector of ids (eg id column)}

\item{id_per_plot}{number of ids per plot. Default to 9}

\item{.x}{vector of values}

\item{.nchunk}{number of chunks to identify}
}
\description{
split IDs into groups to use for subsequent plotting

chunk
}
\details{
works very well with hadley wickham's purrr package to create a column
to split on then subsequently plot, see \code{vignette("Multiplot")} for details

chunk by group, unique values, and return as a vector or a list with elememts
}
\examples{
#chunking will provide the chunk index by splitting the data as evenly as possible
# into the number chunks specified
letters[1:9]

chunk(letters[1:9], 3)

letters[c(1, 1, 1:7)]
chunk(letters[c(1, 1, 1:7)], 3)

# sometimes you want to evenly chunk by unique values rather than purely balancing
chunk_grp(c(1, 1, 1:7), 3)

# a next step after chunking is splitting into a list, so this does thus for you

# chunk list will both split the data and keep the original values
chunk_list(letters[1:9], 3)

chunk_list(c(letters[1], letters[1], letters[1:7]), 3)

# in this case ragged arrays will be created to keep the number of 
# unique elements consistent as possible between chunks
chunk_grp_list(c(letters[1], letters[1], letters[1:7]), 3)
}
