% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneComp_Volume_RateConstant.R
\name{OneComp_Volume_RateConstant}
\alias{OneComp_Volume_RateConstant}
\title{Convert pharmacokinetic parameters for one compartment model}
\usage{
OneComp_Volume_RateConstant(V1,k10,
             V1.sd=NA,k10.sd=NA,covar=c(V1k10=0))
}
\arguments{
\item{V1}{The volume of distribution of compartment 1}

\item{k10}{elimination rate constant}

\item{V1.sd}{standard error of V1}

\item{k10.sd}{standard error of k10}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with volume of distribution (V1) and
elimination rate constant (k10)
}
\examples{
OneComp_Volume_RateConstant(V1=8,k10=0.5,V1.sd=0.01,k10.sd=0.002)

}
\references{
\url{www.nonmemcourse.com/convert.xls}
}
