% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plfd.R
\name{plfd}
\alias{plfd}
\title{PLFD}
\usage{
plfd(x1, x2, r0, c0, blockList, blockMode = NULL, permNum = 100, alpha = 0)
}
\arguments{
\item{x1}{Array of \mjeqn{r \times c \times n_1}{r\emph{c}n1}, samples from group 1.}

\item{x2}{Array of \mjeqn{r \times c \times n_2}{r\emph{c}n2}, samples from group 2.}

\item{r0, c0}{Row and column size of blocks. See details.}

\item{blockList}{List including the index set of pre-specified blocks. See details.}

\item{blockMode}{How the differential structure of \code{M1-M2} are detected.
The default (\code{blockMode=NULL}) does NOT detect the structure of feature blocks.
If \code{blockMode="fd"}(or \code{"forward"}), a forward stepwise procedure is conducted to
detect the nonzero positions of feature blocks, wherein BIC serves as the stopping rule.}

\item{permNum}{Round of permutation.}

\item{alpha}{The upper-\mjeqn{\alpha}{alpha} quantile of the permutation statistic.}
}
\value{
List, \itemize{
\item \code{paras} List of the parameters of feature blocks.
\item \code{y} Self-predicted results for training data. It is a matrix of
\mjeqn{(n_1+n_2)\times 2}{(n1+n2)*2}, the first column is the
scores and the second column is the predicted labels.
\item \code{mcr} The self-predicted misclassification rate for training samples.
\item \code{ytest.hat} The predicted result for \code{xtest} if it is provided. It is a
matrix where the first column is scores and the second column is predicted group.
\item \code{mcr.test} The misclassification rate for \code{xtest} if \code{ytest} is provided.
}
}
\description{
\loadmathjax
A portmanteau local feature discrimination (PLFD) approach to the classification with
high-dimensional matrix-variate data.
}
\details{
There are two ways to specify the blocks under consideration. In the case that
the matrix-variate is partition into non-overlapping blocks that share the common
row size and column size, these sizes can be specified by \code{r0} and \code{c0}. Otherwise, the
blocks can be flexibly specified by parameter \code{blockList}, which should be a list in
which each element includes \code{rIdx} and \code{cIdx} corresponding to the row and column index
set of a block. See examples.
}
\examples{
set.seed(2020)
rDim <- 20
cDim <- 20

n1 <- n2 <- 50
x1 <- array(rnorm(rDim*cDim*n1, mean=0.0), dim=c(rDim, cDim, n1))
x2 <- array(rnorm(rDim*cDim*n2, mean=1.0), dim=c(rDim, cDim, n2))

ntest <- 50
xtest <- array(rnorm(rDim*cDim*ntest, mean=1.0), dim=c(rDim, cDim, ntest))
ytest <- rep(2, ntest)

## Uniform partition
print( plfd(x1, x2, r0=5, c0=5) )

## Pre-specify feature blocks
blockList <- list(list(rIdx=1:5, cIdx=1:5), 
                  list(rIdx=6:10, cIdx=1:5), 
                  list(rIdx=3:9, cIdx=2:8))
print( plfd.model <- plfd(x1, x2, blockList=blockList) )

## Predict
predict(plfd.model, xtest, ytest)

}
\references{
Z. Xu, S. Luo and Z. Chen. (2021). A Portmanteau Local Feature Discrimination
Approach to the Classification with High-dimensional Matrix-variate Data. Sankhya A.
\doi{10.1007/s13171-021-00255-2}
}
