% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{bicPLMIX}
\alias{bicPLMIX}
\title{BIC for a mixture of Plackett-Luce models}
\usage{
bicPLMIX(max_log_lik, ref_known, weights, pi_inv, ref_vary)
}
\arguments{
\item{max_log_lik}{Maximized log-likelihood value.}

\item{ref_known}{Logical: whether the component-specific reference orders are known (not to be estimated).}

\item{weights}{Numeric vector of \eqn{G} mixture weights.}

\item{pi_inv}{Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial orderings.}

\item{ref_vary}{Logical: whether the reference orders vary across mixture components.}
}
\value{
A list of two named objects:

 \item{\code{max_log_lik}}{ The \code{max_log_lik} argument.}
 \item{\code{bic}}{ BIC value.}
}
\description{
Compute BIC value for a mixture of Plackett-Luce models fitted to partial orderings.
}
\details{
The \code{max_log_lik} argument corresponding to the MLE solution can be obtained from the MAP estimation with flat priors by using the \code{\link{mapPLMIX}} function with the default prior setting.
}
\examples{
library(PLMIX)
data(d_carconf)
K <- ncol(d_carconf)
G <- 3
n.starting=2
outputMAP_multistart <- mapPLMIX_multistart(pi_inv=d_carconf, K=K, G=G, 
                                            n_start=n.starting, n_iter=400*G)
outputMAP_multistart$mod$bic
# Equivalently,
bicPLMIX(max_log_lik=max(outputMAP_multistart$mod$log_lik), ref_known=TRUE, 
         weights=outputMAP_multistart$mod$W_map, pi_inv=d_carconf, ref_vary=FALSE)$bic

}
\author{
Cristina Mollica and Luca Tardella
}
\references{
Mollica, C., Tardella, L. (2016). Bayesian Plackett-Luce mixture models for partially ranked data. \emph{Psychometrika} (published online), DOI: 10.1007/s11336-016-9530-0.

Mollica, C., Tardella, L. (2014). Epitope profiling via mixture modeling for ranked data. \emph{Statistics in Medicine}, \bold{33}(21), pages 3738--3758, ISSN: 0277-6715, DOI: 10.1002/sim.6224.
}
\seealso{
\code{\link{mapPLMIX}}
}

