% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{make_complete}
\alias{make_complete}
\title{Completion of partial rankings/orderings}
\usage{
make_complete(data, format = c("ordering", "ranking"), nranked = NULL,
  probitems = rep(1, K))
}
\arguments{
\item{data}{Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial sequences.}

\item{format}{Character string indicating the format of the \code{data} argument.}

\item{nranked}{Optional numeric vector of length \eqn{N} with the number of items ranked by each sample unit.}

\item{probitems}{Numeric vector with the \eqn{K} item-specific probabilities to be employed for the random generation of the missing positions (normalization is not necessary). See Details for further explanation. Default is equal probabilities.}
}
\value{
A list of two named objects:

 \item{\code{completedata}}{ Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of complete sequences.}	
 \item{\code{nranked}}{ Numeric vector of length \eqn{N} with the number of items ranked by each sample unit of the input \code{data}.}
}
\description{
Return complete rankings/orderings from partial sequences relying on a random generation of the missing positions.
}
\details{
The completion of the partial top rankings/orderings is performed according to the Plackett-Luce scheme, that is, with a sampling without replacement of the not-ranked items by using the positive values in the \code{probitems} argument as support parameters.  The returned \code{completedata} matrix has the same format of the input \code{data}.
}
\examples{
library(PLMIX)
data(d_dublinwest)
head(d_dublinwest)
K <- ncol(d_dublinwest)
top_item_freq <- tabulate(d_dublinwest[,1], nbins=K)
set.seed(57524)
d_dublinwest_completed <- make_complete(data=d_dublinwest, format="ordering", 
                                        probitems=top_item_freq)
head(d_dublinwest_completed$completedata)
}
\author{
Cristina Mollica and Luca Tardella
}
\references{
Mollica, C., Tardella, L. (2016). Bayesian Plackett-Luce mixture models for partially ranked data. \emph{Psychometrika} (published online), DOI: 10.1007/s11336-016-9530-0.
}

