% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNLDAfit-S3methods.R
\name{coef.PLNLDAfit}
\alias{coef.PLNLDAfit}
\title{Extracts model coefficients from objects returned by \code{\link[=PLNLDA]{PLNLDA()}}}
\usage{
\method{coef}{PLNLDAfit}(object, ...)
}
\arguments{
\item{object}{an R6 object with class PLNLDAfit}

\item{...}{additional parameters for S3 compatibility. Not used}
}
\value{
Either NULL or a matrix of coefficients extracted from the PLNLDAfit model.
}
\description{
The method for objects returned by \code{\link[=PLNLDA]{PLNLDA()}} only returns
coefficients associated to the \deqn{\Theta} part of the model (see the PLNLDA vignette
for mathematical details).
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLNLDA <- PLNLDA(Abundance ~ Wind, grouping = Group, data = trichoptera)
coef(myPLNLDA)
}
