% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNfamily-class.R
\name{PLNfamily}
\alias{PLNfamily}
\title{An R6 Class to represent a collection of PLNfit}
\description{
super class for \code{\link{PLNPCAfamily}} and \code{\link{PLNnetworkfamily}}

This class comes with a set of methods, some of them being useful for the user:
See the documentation for \code{\link[=getBestModel.PLNnetworkfamily]{getBestModel}},
\code{\link[=getModel.PLNnetworkfamily]{getModel}} and  \code{\link[=plot.PLNnetworkfamily]{plot}}.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{responses}}{the matrix of responses common to every models}

\item{\code{covariates}}{the matrix of covariates common to every models}

\item{\code{offsets}}{the matrix of offsets common to every models}

\item{\code{weights}}{the vector of observation weights}

\item{\code{models}}{a list of \code{\link[=PLNnetworkfit]{PLNnetworkfit}} object, one per penalty.}

\item{\code{inception}}{a \code{\link[=PLNfit]{PLNfit}} object, obtained when no sparsifying penalty is applied.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{criteria}}{a data frame with the values of some criteria (variational lower bound J, BIC, ICL and R2) for the different models.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PLNfamily$new()}}
\item \href{#method-postTreatment}{\code{PLNfamily$postTreatment()}}
\item \href{#method-getModel}{\code{PLNfamily$getModel()}}
\item \href{#method-plot}{\code{PLNfamily$plot()}}
\item \href{#method-show}{\code{PLNfamily$show()}}
\item \href{#method-print}{\code{PLNfamily$print()}}
\item \href{#method-clone}{\code{PLNfamily$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$new(responses, covariates, offsets, weights, control)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-postTreatment"></a>}}
\subsection{Method \code{postTreatment()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$postTreatment()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getModel"></a>}}
\subsection{Method \code{getModel()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$getModel(var, index = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\subsection{Method \code{plot()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$plot(criteria, annotate = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\subsection{Method \code{show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$show()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
