% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetworkfamily-class.R
\name{PLNnetworkfamily}
\alias{PLNnetworkfamily}
\title{An R6 Class to represent a collection of PLNnetworkfit}
\description{
The function \code{\link{PLNnetwork}} produces an instance of this class.

This class comes with a set of methods, some of them being useful for the user:
See the documentation for \code{\link[=getBestModel.PLNnetworkfamily]{getBestModel}},
\code{\link[=getModel.PLNnetworkfamily]{getModel}} and  \code{\link[=plot.PLNnetworkfamily]{plot}}.
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
fits <- PLNnetwork(Abundance ~ 1, data = trichoptera)
class(fits)
}
\seealso{
The function \code{\link{PLNnetwork}}, the class \code{\link[=PLNnetworkfit]{PLNnetworkfit}}
}
\section{Super class}{
\code{\link[PLNmodels:PLNfamily]{PLNmodels::PLNfamily}} -> \code{PLNnetworkfamily}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{responses}}{the matrix of responses common to every models}

\item{\code{covariates}}{the matrix of covariates common to every models}

\item{\code{offsets}}{the matrix of offsets common to every models}

\item{\code{weights}}{the vector of observation weights}

\item{\code{models}}{a list of \code{\link[=PLNnetworkfit]{PLNnetworkfit}} object, one per penalty.}

\item{\code{inception}}{a \code{\link[=PLNfit]{PLNfit}} object, obtained when no sparsifying penalty is applied.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{responses}}{the matrix of responses common to every models}

\item{\code{covariates}}{the matrix of covariates common to every models}

\item{\code{offsets}}{the matrix of offsets common to every models}

\item{\code{weights}}{the vector of observation weights}

\item{\code{penalties}}{the sparsity level of the network in the successively fitted models}

\item{\code{models}}{a list of \code{\link[=PLNnetworkfit]{PLNnetworkfit}} object, one per penalty.}

\item{\code{inception}}{a \code{\link[=PLNfit]{PLNfit}} object, obtained when no sparsifying penalty is applied.}

\item{\code{criteria}}{a data frame with the values of some criteria (variational lower bound J, BIC, ICL and R2) for the different models.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PLNnetworkfamily$new()}}
\item \href{#method-optimize}{\code{PLNnetworkfamily$optimize()}}
\item \href{#method-stability_selection}{\code{PLNnetworkfamily$stability_selection()}}
\item \href{#method-coefficient_path}{\code{PLNnetworkfamily$coefficient_path()}}
\item \href{#method-getBestModel}{\code{PLNnetworkfamily$getBestModel()}}
\item \href{#method-plot}{\code{PLNnetworkfamily$plot()}}
\item \href{#method-plot_stars}{\code{PLNnetworkfamily$plot_stars()}}
\item \href{#method-plot_objective}{\code{PLNnetworkfamily$plot_objective()}}
\item \href{#method-show}{\code{PLNnetworkfamily$show()}}
\item \href{#method-clone}{\code{PLNnetworkfamily$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="getModel">}\href{../../PLNmodels/html/PLNfamily.html#method-getModel}{\code{PLNmodels::PLNfamily$getModel()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="postTreatment">}\href{../../PLNmodels/html/PLNfamily.html#method-postTreatment}{\code{PLNmodels::PLNfamily$postTreatment()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="print">}\href{../../PLNmodels/html/PLNfamily.html#method-print}{\code{PLNmodels::PLNfamily$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$new(
  penalties,
  responses,
  covariates,
  offsets,
  weights,
  model,
  control
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\subsection{Method \code{optimize()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$optimize(control)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stability_selection"></a>}}
\subsection{Method \code{stability_selection()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$stability_selection(
  subsamples = NULL,
  control = list(),
  mc.cores = 1
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-coefficient_path"></a>}}
\subsection{Method \code{coefficient_path()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$coefficient_path(precision = TRUE, corr = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getBestModel"></a>}}
\subsection{Method \code{getBestModel()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$getBestModel(
  crit = c("BIC", "loglik", "R_squared", "EBIC", "StARS"),
  stability = 0.9
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\subsection{Method \code{plot()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$plot(
  criteria = c("loglik", "pen_loglik", "BIC", "EBIC"),
  log.x = TRUE,
  annotate
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_stars"></a>}}
\subsection{Method \code{plot_stars()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$plot_stars(stability = 0.9, log.x = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_objective"></a>}}
\subsection{Method \code{plot_objective()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$plot_objective()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\subsection{Method \code{show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$show()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNnetworkfamily$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
