% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNLDAfit-class.R
\name{PLNLDAfit_diagonal}
\alias{PLNLDAfit_diagonal}
\title{An R6 Class to represent a PLNfit in a LDA framework with diagonal covariance}
\description{
The function \code{\link[=PLNLDA]{PLNLDA()}} produces an instance of an object with class \code{\link{PLNLDAfit}}.

This class comes with a set of methods, some of them being useful for the user:
See the documentation for the methods inherited by \code{\link[=PLNfit]{PLNfit()}}, the \code{\link[=plot]{plot()}} method for
LDA visualization and \code{\link[=predict]{predict()}} method for prediction
}
\examples{
\dontrun{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLNLDA <- PLNLDA(Abundance ~ 1, data = trichoptera, control = PLN_param(covariance = "diagonal"))
class(myPLNLDA)
print(myPLNLDA)
}
}
\section{Super classes}{
\code{\link[PLNmodels:PLNfit]{PLNmodels::PLNfit}} -> \code{\link[PLNmodels:PLNLDAfit]{PLNmodels::PLNLDAfit}} -> \code{PLNLDAfit_diagonal}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{vcov_model}}{character: the model used for the residual covariance}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PLNLDAfit_diagonal-new}{\code{PLNLDAfit_diagonal$new()}}
\item \href{#method-PLNLDAfit_diagonal-clone}{\code{PLNLDAfit_diagonal$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="optimize_vestep"><a href='../../PLNmodels/html/PLNfit.html#method-PLNfit-optimize_vestep'><code>PLNmodels::PLNfit$optimize_vestep()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="predict_cond"><a href='../../PLNmodels/html/PLNfit.html#method-PLNfit-predict_cond'><code>PLNmodels::PLNfit$predict_cond()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="print"><a href='../../PLNmodels/html/PLNfit.html#method-PLNfit-print'><code>PLNmodels::PLNfit$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="update"><a href='../../PLNmodels/html/PLNfit.html#method-PLNfit-update'><code>PLNmodels::PLNfit$update()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNLDAfit" data-id="optimize"><a href='../../PLNmodels/html/PLNLDAfit.html#method-PLNLDAfit-optimize'><code>PLNmodels::PLNLDAfit$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNLDAfit" data-id="plot_LDA"><a href='../../PLNmodels/html/PLNLDAfit.html#method-PLNLDAfit-plot_LDA'><code>PLNmodels::PLNLDAfit$plot_LDA()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNLDAfit" data-id="plot_correlation_map"><a href='../../PLNmodels/html/PLNLDAfit.html#method-PLNLDAfit-plot_correlation_map'><code>PLNmodels::PLNLDAfit$plot_correlation_map()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNLDAfit" data-id="plot_individual_map"><a href='../../PLNmodels/html/PLNLDAfit.html#method-PLNLDAfit-plot_individual_map'><code>PLNmodels::PLNLDAfit$plot_individual_map()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNLDAfit" data-id="postTreatment"><a href='../../PLNmodels/html/PLNLDAfit.html#method-PLNLDAfit-postTreatment'><code>PLNmodels::PLNLDAfit$postTreatment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNLDAfit" data-id="predict"><a href='../../PLNmodels/html/PLNLDAfit.html#method-PLNLDAfit-predict'><code>PLNmodels::PLNLDAfit$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNLDAfit" data-id="setVisualization"><a href='../../PLNmodels/html/PLNLDAfit.html#method-PLNLDAfit-setVisualization'><code>PLNmodels::PLNLDAfit$setVisualization()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNLDAfit" data-id="show"><a href='../../PLNmodels/html/PLNLDAfit.html#method-PLNLDAfit-show'><code>PLNmodels::PLNLDAfit$show()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNLDAfit_diagonal-new"></a>}}
\if{latex}{\out{\hypertarget{method-PLNLDAfit_diagonal-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{\link{PLNfit}} model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNLDAfit_diagonal$new(
  grouping,
  responses,
  covariates,
  offsets,
  weights,
  formula,
  control
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{grouping}}{a factor specifying the class of each observation used for discriminant analysis.}

\item{\code{responses}}{the matrix of responses (called Y in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{covariates}}{design matrix (called X in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{offsets}}{offset matrix (called O in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{weights}}{an optional vector of observation weights to be used in the fitting process.}

\item{\code{formula}}{model formula used for fitting, extracted from the formula in the upper-level call}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNLDAfit_diagonal-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PLNLDAfit_diagonal-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNLDAfit_diagonal$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
