% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadeAllPairsTest.R
\name{quadeAllPairsTest}
\alias{quadeAllPairsTest}
\alias{quadeAllPairsTest.default}
\title{All-Pairs Comparisons for
Unreplicated Blocked Data (Quade's All-Pairs Test)}
\usage{
quadeAllPairsTest(y, ...)

\method{quadeAllPairsTest}{default}(y, groups, blocks, dist = c("TDist",
  "Normal"), p.adjust.method = p.adjust.methods, ...)
}
\arguments{
\item{y}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}. Ignored with a warning if \code{"x"} is a list.}

\item{blocks}{a vector or factor object giving the block for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{dist}{the test distribution. Defaults to \code{"TDist"}.}

\item{p.adjust.method}{method for adjusting p values
(see \code{\link{p.adjust}}).}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Quade multiple-comparison test for unreplicated
blocked data.
}
\details{
For all-pairs comparisons of unreplicated blocked data
Quade's test can be applied.
A total of \eqn{m = k(k-1)/2}
hypotheses can be tested. The null hypothesis
H\eqn{_{ij}: \theta_i = \theta_j} is tested in the two-tailed test
against the alternative
A\eqn{_{ij}: \theta_i \ne \theta_j, ~~ i \ne j}.

The function has included two methods for approximate p-value estimation:
\describe{
\item{TDist}{p-values are computed from the t distribution}
\item{Normal}{p-values are computed from the standard normal distribution}
}

If no p-value adjustment is performed (\code{p.adjust.method = "none"}),
than a simple protected test is recommended, i.e.
all-pairs comparisons should only be applied after a significant
\code{\link{quade.test}}. However, any method as implemented in
\code{\link{p.adjust.methods}} can be selected by the user.
}
\examples{
## Sachs, 1997, p. 675
## Six persons (block) received six different diuretics
## (A to F, treatment).
## The responses are the Na-concentration (mval)
## in the urine measured 2 hours after each treatment.
##
y <- matrix(c(
3.88, 5.64, 5.76, 4.25, 5.91, 4.33, 30.58, 30.14, 16.92,
23.19, 26.74, 10.91, 25.24, 33.52, 25.45, 18.85, 20.45,
26.67, 4.44, 7.94, 4.04, 4.4, 4.23, 4.36, 29.41, 30.72,
32.92, 28.23, 23.35, 12, 38.87, 33.12, 39.15, 28.06, 38.23,
26.65),nrow=6, ncol=6,
dimnames=list(1:6, LETTERS[1:6]))
print(y)

## Global test
quade.test(y)

## All-pairs comparisons
quadeAllPairsTest(y, dist="TDist", p.adjust.method="holm")

}
\references{
W. J. Conover (1999), \emph{Practical nonparametric Statistics},
3rd. Edition, Wiley.

N. A. Heckert and J. J. Filliben (2003). NIST Handbook 148:
Dataplot Reference Manual, Volume 2: Let Subcommands and Library Functions.
National Institute of Standards and Technology Handbook Series, June 2003.

D. Quade (1979), Using weighted rankings in the analysis of complete
blocks with additive block effects. \emph{Journal of the American
Statistical Association}, 74, 680-683.
}
\seealso{
\code{\link{quade.test}}, \code{\link{friedmanTest}}
}
\concept{
AllPairsComparison

TwoWayRankAnova
}
\keyword{htest}
\keyword{nonparametric}
