% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalScoresManyOneTest.R
\name{normalScoresManyOneTest}
\alias{normalScoresManyOneTest}
\alias{normalScoresManyOneTest.default}
\alias{normalScoresManyOneTest.formula}
\title{Lu-Smith Many-One Comparisons Normal Scores Test}
\usage{
normalScoresManyOneTest(x, ...)

\method{normalScoresManyOneTest}{default}(
  x,
  g,
  alternative = c("two.sided", "greater", "less"),
  p.adjust.method = c("single-step", p.adjust.methods),
  ...
)

\method{normalScoresManyOneTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("two.sided", "greater", "less"),
  p.adjust.method = c("single-step", p.adjust.methods),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{two.sided}.}

\item{p.adjust.method}{method for adjusting p values (see \code{\link{p.adjust}}).}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Lu-Smith multiple comparison
normal scores test with one control.
}
\details{
For many-to-one comparisons in an one-factorial layout
with non-normally distributed residuals Lu and Smith's
normal scores transformation can be used prior to
a many-to-one comparison test. A total of \eqn{m = k-1}
hypotheses can be tested. The null hypothesis
H\eqn{_{i}: F_0(x) = F_i(x)} is tested in the two-tailed test
against the alternative
A\eqn{_{i}: F_0(x) \ne F_i(x), ~~ 1 \le i \le k-1}.
For \code{p.adjust.method = "single-step"} the
multivariate t distribution is used to calculate
p-values (see \code{\link[mvtnorm]{pmvt}}). Otherwise, the
t-distribution is used for the calculation of p-values
with a latter p-value adjustment as
performed by \code{\link{p.adjust}}.
}
\examples{
## Data set PlantGrowth
## Global test
normalScoresTest(weight ~ group, data = PlantGrowth)

## Lu-Smith's many-one comparison test
ans <- normalScoresManyOneTest(weight ~ group, data = PlantGrowth, p.adjust.method = "holm")
summary(ans)
}
\references{
Lu, H., Smith, P. (1979) Distribution of normal scores statistic
for nonparametric one-way analysis of variance.
\emph{Journal of the American Statistical Association} \bold{74}, 715--722.
}
\seealso{
\code{\link{normalScoresTest}}, \code{\link{normalScoresAllPairsTest}}, \code{\link[SuppDists]{normOrder}}, \code{\link[mvtnorm]{pmvt}}.
}
\concept{ManyOneComparison}
\concept{NormalScores}
\keyword{htest}
\keyword{nonparametric}
