% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwManyOneDunnTest.R
\name{kwManyOneDunnTest}
\alias{kwManyOneDunnTest}
\alias{kwManyOneDunnTest.default}
\alias{kwManyOneDunnTest.formula}
\title{Dunn's Many-to-One Rank Comparison Test}
\usage{
kwManyOneDunnTest(x, ...)

\method{kwManyOneDunnTest}{default}(
  x,
  g,
  alternative = c("two.sided", "greater", "less"),
  p.adjust.method = c("single-step", p.adjust.methods),
  ...
)

\method{kwManyOneDunnTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("two.sided", "greater", "less"),
  p.adjust.method = c("single-step", p.adjust.methods),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{two.sided}.}

\item{p.adjust.method}{method for adjusting p values
(see \code{\link{p.adjust}}).}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
\item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Dunn's non-parametric many-to-one comparison
test for Kruskal-type ranked data.
}
\details{
For many-to-one comparisons (pairwise comparisons with one control)
in an one-factorial layout with non-normally distributed
residuals Dunn's non-parametric test can be performed.
Let there be \eqn{k} groups including the control,
then the number of treatment levels is \eqn{m = k - 1}.
Then \eqn{m} pairwise comparisons can be performed between
the \eqn{i}-th treatment level and the control.
H\eqn{_i: \theta_0 = \theta_i} is tested in the two-tailed case against
A\eqn{_i: \theta_0 \ne \theta_i, ~~ (1 \le i \le m)}.

If \code{p.adjust.method == "single-step"} is selected,
the \eqn{p}-values will be computed
from the multivariate normal distribution. Otherwise,
the \eqn{p}-values are computed from the standard normal distribution using
any of the \eqn{p}-adjustment methods as included in \code{\link{p.adjust}}.
}
\note{
Factor labels for \code{g} must be assigned in such a way,
that they can be increasingly ordered from zero-dose
control to the highest dose level, e.g. integers {0, 1, 2, ..., k} or
letters {a, b, c, ...}. Otherwise the function may not
select the correct values for intended zero-dose control.

It is safer, to i) label the factor levels as given above,
and to ii) sort the data according to increasing dose-levels
prior to call the function (see \code{\link{order}}, \code{\link{factor}}).
}
\examples{
## Data set PlantGrowth
## Global test
kruskalTest(weight ~ group, data = PlantGrowth)

## Conover's many-one comparison test
## single-step means p-value from multivariate t distribution
ans <- kwManyOneConoverTest(weight ~ group, data = PlantGrowth,
                             p.adjust.method = "single-step")
summary(ans)

## Conover's many-one comparison test
ans <- kwManyOneConoverTest(weight ~ group, data = PlantGrowth,
                             p.adjust.method = "holm")
summary(ans)

## Dunn's many-one comparison test
ans <- kwManyOneDunnTest(weight ~ group, data = PlantGrowth,
                             p.adjust.method = "holm")
summary(ans)

## Nemenyi's many-one comparison test
ans <- kwManyOneNdwTest(weight ~ group, data = PlantGrowth,
                        p.adjust.method = "holm")
summary(ans)

## Many one U test
ans <- manyOneUTest(weight ~ group, data = PlantGrowth,
                        p.adjust.method = "holm")
summary(ans)

## Chen Test
ans <- chenTest(weight ~ group, data = PlantGrowth,
                    p.adjust.method = "holm")
summary(ans)
}
\references{
Dunn, O. J. (1964) Multiple comparisons using rank sums,
\emph{Technometrics} \emph{6}, 241--252.

Siegel, S., Castellan Jr., N. J. (1988) \emph{Nonparametric Statistics
for The Behavioral Sciences}. New York: McGraw-Hill.
}
\seealso{
\code{\link{pmvnorm}}, \code{\link{TDist}}, \code{\link{kruskalTest}},
\code{\link{kwManyOneConoverTest}}, \code{\link{kwManyOneNdwTest}}
}
\concept{kruskalranks}
\keyword{htest}
\keyword{nonparametric}
