% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramsPOUMM.R
\name{covVTipsGivenTreePOUMM}
\alias{covVTipsGivenTreePOUMM}
\title{Variance covariance matrix of the values at the tips of a tree under an OU 
process}
\usage{
covVTipsGivenTreePOUMM(tree, alpha = 0, sigma = 1, sigmae = 0,
  tanc = NULL, tauij = NULL, corr = FALSE)
}
\arguments{
\item{tree}{A phylo object.}

\item{alpha, sigma}{Non-negative numeric values, parameters of the OU process.}

\item{sigmae}{Non-negative numeric value, environmental standard deviation at
the tips.}

\item{tanc}{Numerical matrix with the time-distance from the root of the tree
to the mrca of each tip-couple. If NULL it will be calculated.}

\item{tauij}{Numerical matrix with the time (patristic) distance between each
pair of tips. If NULL, it will be calculated.}

\item{corr}{Logical indicating if a correlation matrix shall be returned.}
}
\value{
a variance covariance or a correlation matrix of the tips in tree.
}
\description{
Variance covariance matrix of the values at the tips of a tree under an OU 
process
}
\references{
(Hansen 1997) Stabilizing selection and the comparative analysis 
  of adaptation.
}

