% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramsPOUMM.R
\name{covPOUMM}
\alias{covPOUMM}
\title{Expected covariance of two tips at given root-tip time and phylogenetic distance}
\usage{
covPOUMM(alpha, sigma, sigmae, t, tau, tanc = t - tau/2, corr = FALSE,
  as.matrix = FALSE)
}
\arguments{
\item{alpha, sigma, sigmae}{POUMM parameters}

\item{t}{A non-negative number or vector time from the beginning of the POUMM
process (root-tip distance). If a vector, the evaluation is done on each 
couple (row) from cbind(t, tau).}

\item{tau}{A non-negative number or vector indicating the phylogenetic 
distance between two tips, each of them located at time t from the root. 
If a vector, the evaluation is done on each couple (row) from cbind(t, tau).}

\item{tanc}{A non-negative number or vector indication the root-mrca distance
for a couple of tips. Defaults to t-tau/2 corresponding to an ultrametric tree.}

\item{corr}{Logical indicating whether correlation should be returned instead
of covariance.}

\item{as.matrix}{Logical indicating if a variance-covariance matrix should be
returned.}
}
\value{
If as.matrix == FALSE, a number. Otherwise a two by two symmetric
  matrix. If t or tau is a vector of length bigger than 1, then a vector of 
  numbers or a list of matrices.
}
\description{
Expected covariance of two tips at given root-tip time and phylogenetic distance
}
\details{
The function assumes that the two tips are at equal distance t from 
the root. This implies that the root-tip distance of their mrca is t - tau/2.
}
