% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPOUMM.R
\name{maxLikPOUMMGivenTreeVTips}
\alias{maxLikPOUMMGivenTreeVTips}
\title{Find a maximum likelihood fit of the POUMM model}
\usage{
maxLikPOUMMGivenTreeVTips(loglik, pruneInfo, parLower, parUpper,
  parInitML = NULL, control = list(factr = 1e+08, fnscale = -1),
  verbose = FALSE, debug = FALSE, ...)
}
\arguments{
\item{loglik}{function(par, memo, parFixedNoAlpha)}

\item{pruneInfo}{a list-object returned by the pruneTree(tree, z) function.}

\item{parLower, parUpper}{Two named numeric vectors indicating the boundaries of 
the search region. Default values are parLower = c(alpha = 0, theta = 0, 
sigma = 0, sigmae = 0) and parUpper = c(alpha = 100, theta = 10, sigma = 20, 
sigmae = 10).}

\item{parInitML}{A named vector (like parLower and parUpper) or a list of such
vectors - starting points for optim.}

\item{control}{List of parameters passed on to optim, default 
list(factr = 1e8, fnscale = -1), see ?optim.}

\item{verbose}{A logical indicating whether to print informative messages on 
the standard output.}

\item{debug}{A logical indicating whether to print debug messages 
(currently not implemented).}

\item{...}{currently not used.}
}
\value{
a list containing an element par and an element value as well as the 
  parameters passed
}
\description{
Find a maximum likelihood fit of the POUMM model
}
