# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

get_fixedNumber_neighbors <- function(x, number = 6L) {
    .Call(`_PRECAST_get_fixedNumber_neighbors`, x, number)
}

#' @title
#' getneighborhood_fast
#' @description
#' an efficient function to find the neighborhood based on the matrix of position and a pre-defined cutoff
#'
#' @param x is a n-by-2 matrix of position.
#' @param radius is a threashold of Euclidean distance to decide whether a spot is an neighborhood of another spot. For example, if the Euclidean distance between spot A and B is less than cutoff, then A is taken as the neighbourhood of B. 
#' @return A sparse matrix containing the neighbourhood
#'
#' @export
getneighborhood_fast <- function(x, radius) {
    .Call(`_PRECAST_getneighborhood_fast`, x, radius)
}

#' Calculate column-wise or row-wise mean
#' @param sp_data A sparse matrix
#' @param rowMeans A boolean value, whether to calculate row-wise mean
#' @return A n x 1 or p x 1 matrix 
#' @export
sp_means_Rcpp <- function(sp_data, rowMeans = FALSE) {
    .Call(`_PRECAST_sp_means_Rcpp`, sp_data, rowMeans)
}

#' Calculate column-wise or row-wise sum
#' @param sp_data A sparse matrix
#' @param rowSums A boolean value, whether to calculate row-wise sum
#' @return A n x 1 or p x 1 matrix 
#' @export
sp_sums_Rcpp <- function(sp_data, rowSums = FALSE) {
    .Call(`_PRECAST_sp_sums_Rcpp`, sp_data, rowSums)
}

#' @title
#' idrsc2Cpp
#' @description
#' the main function of ICM-EM algorithm for integrative dimension reduction and clustering.
#'
#' @param Xlist is a r_max-length Rcpp list, including log-normalized gene expression matrix of each sample.
#' @param Adjlist is a r_max-length Rcpp list, including adjoint matrix (obtained by spatial coordinates) of each sample.
#' @param y_intlist is a r_max-length Rcpp list, including initial cluster labels (vector) of each sample.
#' @param Mu_int is a K-by-q matrix, where each row is an intial mean component of gaussian mixture model shared by all samples.
#' @param Sigma_int is a q-by-q-by-K array, where each slice is an initial covariance component of GMM that is sample-specified.
#' @param W_int is a p-by-q matrix that is the intial loading matrix in the probabilistic PCA model.
#' @param Lam_int is a r_max-by-p matrix, where each row is an initial variance vector of error in PPCA model for each sample.
#' @param Psi_int is a q-by-q-by-r_max array, where each slice is an initialized covariance of CAR model for each sample.
#' @param alpha is a K-length vector that equals to zero in Potts model.
#' @param beta_int is a positive real (0~5) that is the initial value of smoothing parameter in Potts model
#' @param beta_grid is a vector that is a grid for searching smoothing parameter beta in the ICM step.
#' @param maxIter_ICM is a positive integer that specifies the maximum iterations in ICM step.
#' @param maxIter is a positive integer that specifies the maximum iterations in this ICM-EM algorithm.
#' @param epsLogLik is a postive real that specifies the relative tolerance value of pseudo observed log-likelihood.
#' @param verbose is a bool indicating whether output the information of algorithm
#' @param homo is a bool indicating whether the homogeneous error covariance in PPCA model is used.
#' @param homoClust is a bool indicating whehter mixture covariance only related to r, or related to r and k.
#' @param Sigma_diag is a bool indicating whether the mixture covariance is a diagonal matrix.
#' @param mix_prop_heter is a bool indicating whether the smoothing parameter beta_r is different among samples or shared by all samples
#' @param Sp2 is a bool indicating whether the CAR model is used.
#' @return A list includes cluster (cluster labels list), hZ (the posterior estimation of Z), hV (predictions of V)
#'
idrsc2Cpp <- function(Xlist, Adjlist, Adjlist_car, hZ, ymat, Mu_intList, Sigma_intList, W_int, alpha_intList, beta_int, beta_grid, maxIter_ICM, maxIter, epsLogLik, verbose, homo = FALSE, homoClust = FALSE, Sigma_diag = FALSE, mix_prop_heter = FALSE, Sp2 = TRUE, maxK = 16L, minK = 4L, coreNum = 1L) {
    .Call(`_PRECAST_idrsc2Cpp`, Xlist, Adjlist, Adjlist_car, hZ, ymat, Mu_intList, Sigma_intList, W_int, alpha_intList, beta_int, beta_grid, maxIter_ICM, maxIter, epsLogLik, verbose, homo, homoClust, Sigma_diag, mix_prop_heter, Sp2, maxK, minK, coreNum)
}

#' @noRd
#' Evaluate class label of neighbor matrix.
NULL

#' @noRd
#' 
calculateWeight <- function(X, nPCs) {
    .Call(`_PRECAST_calculateWeight`, X, nPCs)
}

wpcaCpp <- function(X, nPCs, weighted = TRUE) {
    .Call(`_PRECAST_wpcaCpp`, X, nPCs, weighted)
}

