% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_trans_generic.R
\name{proj_trans_generic}
\alias{proj_trans_generic}
\title{Transform a set of coordinates with 'PROJ'}
\usage{
proj_trans_generic(x, target, ..., source = NULL, z_ = 0, t_ = numeric(0))
}
\arguments{
\item{x}{input coordinates (x,y, list or matrix see \code{z_} and \code{t_})}

\item{target}{projection for output coordinates}

\item{...}{ignored}

\item{source}{projection of input coordinates (must be named)}

\item{z_}{optional z coordinate vector}

\item{t_}{optional t coordinate vector}
}
\value{
list of transformed coordinates, with 4-elements \code{x_}, \code{y_}, \code{z_}, \code{t_}
}
\description{
A raw interface to proj_trans_generic in 'PROJ => 6', if it is available.
}
\details{
Input 'x' is assumed to be 2-columns of "x", then "y" coordinates. If "z" or
"t" is required pass these in as named vectors with "z_" and "t_". These
are left empty (zero-length) internally by default, if possible but it seems that
z must always match the length of \code{x} \code{y} if 'xyz' is the output, so for safety this
is always initialized as a zero value vector.
}
\examples{
if (ok_proj6()) {
 proj_trans_generic(cbind(147, -42), "+proj=laea", source = "epsg:4326")
 proj_trans_generic(cbind(147, -42), z_ = -2, "+proj=laea", source = "epsg:4326")
 proj_trans_generic(cbind(147, -42), z_ = -2, t_ = 1, "+proj=laea", source = "epsg:4326")
 }
}
\references{
see the \href{https://proj.org/development/reference/functions.html#coordinate-transformation}{PROJ library documentation}
for details on the underlying functionality
}
