\name{mapforGeneratedData}
\alias{mapforGeneratedData}
\title{Map generated data}
\description{Function to draw the map of a vector when data are generated. }
\usage{
mapforGeneratedData(u, del=NULL, palette='RGB', main='' )
}
\arguments{
\item{u}{A vector of size nSubject to map. The function is only useful when data are generated by generateSampleDataFile.}
\item{del}{A numeric vector of increasing order given the breaks to color the map. By default the centiles of u are used.}
\item{palette}{Color palette to be used. Either 'RGB' (default) Red-Green-Blue, or 'BW' for black and white.}
\item{main}{A string for title.}
}

\section{Authors}{

Aurore J. Lavigne, Department of Epidemiology and Biostatistics, Imperial College London and MRC Biostatistics Unit, Cambridge, UK

Maintainer: Silvia Liverani <liveranis@gmail.com>
}
\references{

Liverani, S., Hastie, D. I., Azizi, L., Papathomas, M. and Richardson, S. (2014) PReMiuM: An R package for Profile Regression Mixture Models using Dirichlet Processes. \emph{Forthcoming in the Journal of Statistical Software}. Available at http://uk.arxiv.org/abs/1303.2836

}
\examples{
inputs=generateSampleDataFile(clusSummaryPoissonNormalSpatial())
mapforGeneratedData(inputs$uCAR)
}


