% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_response}
\alias{plot_response}
\title{Curve or surfaces of the expected reponse agaist the corresponding variable.}
\usage{
plot_response(obj, vars, log_scale = FALSE, length.out = 20,
  color = "blue", size = 1.5)
}
\arguments{
\item{obj}{an object of the class PSTR returned from some functions in the package. Note that the corresponding PSTR model must be estimated first.}

\item{vars}{a vector of column numbers or names (character strings) specifying which variables in the nonlinear part to use.}

\item{log_scale}{a 2-dim vector or scalar specifying whether to take log scale for the variables and the transition variable.}

\item{length.out}{a 2-dim vector or scalar of desired length (number of points) for the parameters. 20 by default.}

\item{color}{the color of the line.}

\item{size}{the size of the line.}
}
\value{
A list of plottable objects from the \code{ggplot2} (for curve) and/or \code{plotly} (for surface) package.
}
\description{
This function plots the curve or the surfaces of the expected reponse agaist the corresponding variable (and the transition variable if surface).
}
\details{
The expected response is the expected value of the dependent variable minus the individual effect and all the other variables times their estimated coefficients.
That is, if the variable is \eqn{z_{k,it}} in both \eqn{x_{it}} and \eqn{z_{it}},
then the function plots the surface of
\deqn{y_{it} - \mu_i - \beta_{-k,0}' x_{-k,it} + \beta_{-k,1}' z_{-k,it} g_{it} - u_{it}}
or simply
\deqn{(\beta_{k,0} + \beta_{k,1}g_{it}) \cdot z_{k,it}}
where \eqn{-k} means with the \eqn{k}th element removed,
against \eqn{z_{k,it}} and \eqn{q_{it}} if \eqn{z_{k,it} \neq q_{it}}.

If \eqn{z_{k,it} = q_{it}}, then the function plots the curve of the expected response defined above against \eqn{z_{k,it}}.

More than one variable can be put in \code{vars}.
If \code{vars} contains the transition variable and the transition variable belongs to the nonlinear part,
the function will plot a curve of the effect-adjusted expected response and the transition variable,
otherwise, the function will plot a 3-D surface of the effect-adjusted expected response against a chosen variable in the nonlinear part and the transition variable.

\code{length.out} takes a vector or a scalar.
The vector must be two dimensional specifying numbers of points in the grid built for the surface.
The first element of the vector corresponds to the variables, and the second to the transition variable.
If it is a scalar, then grid has the same number of points for the variables and the transition varible.

The return value is a list of the same length as \code{vars}, whose elements are plottable objects.
}
\examples{
\donttest{
pstr = NewPSTR(Hansen99, dep='inva', indep=4:20, indep_k=c('vala','debta','cfa','sales'),
    tvars=c('vala','debta','cfa','sales'), iT=14) # create a new PSTR object

# estimate the PSTR model first
pstr = EstPSTR(use=pstr, im=1, iq=1, useDelta=TRUE, par=c(.63,0), method='CG')

# plot the curve and surfaces
ret = plot_response(obj=pstr, vars=1:4, log_scale = c(FALSE,TRUE), length.out=40)
attributes(ret)
ret$vala
ret$debta
}

}
\seealso{
Functions which return an object of the class PSTR and can be input into this function

\code{\link{EstPSTR}}
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{utils}
