% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_transition}
\alias{plot_transition}
\title{Plot the transition function of the estimated PSTR model.}
\usage{
plot_transition(obj, size = 1.5, color = "blue", xlim = NULL,
  ylim = NULL, fill = NULL, alpha = NULL)
}
\arguments{
\item{obj}{an object of the class PSTR returned from some functions in the package. Note that the corresponding PSTR model must be estimated first.}

\item{size}{the size of the circle.}

\item{color}{the color of the circle.}

\item{xlim}{a numeric vector of dimension 2 specifying the limits of x-axis.}

\item{ylim}{a numeric vector of dimension 2 specifying the limits of y-axis.}

\item{fill}{the color used to fill the area on the transition curve with observations, \code{NULL} for not fill, see ggplot2.}

\item{alpha}{a number controlling the transparency of the points and filled area, \code{NULL} for default, see ggplot2.}
}
\value{
A ggplot object. The user can plot it simply by print the object.
}
\description{
This function plots the transition function of the estimated PSTR model.
}
\details{
The funciton uses some functions in the ggplot2 package and aims to give a quick plot of the transtion function.
The user can customize the title, subtitle, caption, x and y labels, for details, read the help file for the \code{labs} function in ggplot2.
}
\examples{
\donttest{
pstr = NewPSTR(Hansen99, dep='inva', indep=4:20, indep_k=c('vala','debta','cfa','sales'),
    tvars=c('vala'), iT=14) # create a new PSTR object

# estimate the PSTR model
pstr = EstPSTR(use=pstr, im=1, iq=1, useDelta=TRUE, par=c(.63,0), method='CG')

# plot the transition function

ret = plot_transition(pstr)
# plot by running
ret

ret = plot_transition(pstr, fill='blue', xlim=c(-2,20), color = "dodgerblue4", size = 2, alpha=.3)
ret
}

}
\seealso{
Functions which return an object of the class PSTR and can be input into this function

\code{\link{EstPSTR}}
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{utils}
