% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSOutcome.R
\name{PSOutcome}
\alias{PSOutcome}
\title{Estimated potential outcome for principal stratification analysis}
\usage{
PSOutcome(PStrataObj, type = c("probability", "RACE"))
}
\arguments{
\item{PStrataObj}{an object of class \code{PStrata} or \code{PStrata_survival}}

\item{type}{whether the causal estimand is survival probability or RACE, ignored for non-survival outcomes.}
}
\value{
An S3 object of type \code{PSOutcome}, containing
\item{outcome_array}{A num_strata * num_treatment * num_iter array of mean outcome if the outcome type is non-survival
or a num_strata * num_treatment * num_time_points * num_iter array of mean outcome if the outcome type is survival.}
\item{is.survival}{A boolean value, whether the outcome type is survival.}
\item{time_points}{The time points at which the outcome is evaluated, if the outcome type is survival.}
The S3 method \code{summary} and \code{plot} can be applied to the returned object.
}
\description{
Create an object useful to present the potential outcomes under each treatment arm
for each principal stratum. Contrasts between treatment arms or principal strata
are easy to obtain from this object.
}
