% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_loadDaily.R
\name{wrcc_loadDaily}
\alias{wrcc_loadDaily}
\title{Load Recent WRCC Monitoring Data}
\usage{
wrcc_loadDaily(baseUrl = "https://haze.airfire.org/monitoring/WRCC/RData/")
}
\arguments{
\item{baseUrl}{location of the WRCC latest data file}
}
\value{
A \emph{ws_monitor} object with WRCC data.
}
\description{
Loads pre-generated .RData files containing the most recent WRCC data.

The daily files are generated once a day, shortly after midnight and contain data for the
previous 45 days. 

For the most recent data, use \code{wrcc_loadLatest()}.

Avaialble RData and associated log files can be seen at:
\href{https://haze.airfire.org/monitoring/WRCC/RData/latest}{https://haze.airfire.org/monitoring/WRCC/RData/latest}
}
\examples{
\dontrun{
wrcc <- wrcc_loadDaily()
}
}
\seealso{
\code{\link{wrcc_load}}

\code{\link{wrcc_loadLatest}}
}
\keyword{WRCC}
