% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skill_ROCPlot.R
\name{skill_ROCPlot}
\alias{skill_ROCPlot}
\title{ROC Plot}
\usage{
skill_ROCPlot(predicted, observed, t1Range = c(0, 100), t2s = seq(10, 100,
  10), n = 101, colors = grDevices::rainbow(length(t2s)))
}
\arguments{
\item{predicted}{vector of predicted values (or a \emph{ws_monitor} object with a single location)}

\item{observed}{vector of observed values (or a \emph{ws_monitor} object with a single location)}

\item{t1Range}{lo and high values used to generate test thresholds for classifying \code{predicted} data}

\item{t2s}{vector of thresholds used to classify \code{observed} data}

\item{n}{number of test thresholds in ROC curve}

\item{colors}{vector of colors used when plotting curves}
}
\description{
This function plots ROC curves for a variety of \code{observed} classification thresholds.
}
\examples{
\dontrun{
# Spokane summer of 2015
airnow <- airnow_load(20150701,20150930)
airnow <- monitor_rollingMean(airnow, width=3)
MonroeSt <- monitor_subset(airnow, monitorIDs="530630047_01")
EBroadway <- monitor_subset(airnow, monitorIDs="530639997_01")
skill_ROCPlot(EBroadway, MonroeSt)
}
}
\references{
\href{https://en.wikipedia.org/wiki/Receiver_operating_characteristic}{Receiver Operating Characteristic}
}
\seealso{
\link{skill_confusionMatrix}

\link{skill_ROC}
}
